/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.items.NMLItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MapleSyrupCauldron
extends FourLayeredCauldronBlock {
    public MapleSyrupCauldron() {
        super(NMLParticleTypes.MAPLE_SYRUP_DROPLET);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean interacted = false;
        ItemStack bottleStack = new ItemStack((ItemLike)NMLItems.MAPLE_SYRUP_BOTTLE.get());
        if (stack.is(Items.GLASS_BOTTLE)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)bottleStack));
            interacted = true;
            MapleSyrupCauldron.lowerFillLevel(state, level, pos);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
        }
        if (stack.is(bottleStack.getItem()) && !this.isFull(state)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
            interacted = true;
            this.raiseFillLevel(state, level, pos);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (this.isEntityInsideContent(state, pos, entity)) {
            if (entity instanceof LivingEntity && (Integer)state.getValue((Property)LEVEL) > 1) {
                level.playSound(null, pos, (SoundEvent)NMLSounds.STICKY_CAULDRON_SLIDE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                entity.makeStuckInBlock(state, new Vec3(0.9, 0.9, 0.9));
            }
            if (!level.isClientSide && entity.isOnFire()) {
                entity.clearFire();
                level.playSound(entity, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

