/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.registry.NMLBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RemainsBlockEntity
extends BrushableBlockEntity {
    public RemainsBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public boolean isValidBlockState(BlockState blockState) {
        return NMLBlockEntities.REMAINS.get().isValid(blockState);
    }

    public BlockEntityType<?> getType() {
        return super.getType();
    }

    public void brushingCompleted(Player player) {
        Skeleton buried;
        Block remainsBlockState;
        if (this.level != null && this.level.getServer() != null && (remainsBlockState = this.getBlockState().getBlock()) instanceof BrushableBlock && (double)this.level.random.nextFloat() < (Double)NMLConfig.BURIED_SPAWNING_CHANCE.get() && (buried = (Skeleton)EntityType.SKELETON.create(this.level)) != null) {
            BlockPos spawningPosition = this.worldPosition.relative(this.getHitDirection());
            if (this.level.getBlockState(spawningPosition) == Blocks.AIR.defaultBlockState()) {
                buried.moveTo(spawningPosition.getCenter());
            } else {
                buried.moveTo((player.getX() + (double)this.worldPosition.getX()) / 2.0, (player.getY() + (double)this.worldPosition.getY()) / 2.0, (player.getZ() + (double)this.worldPosition.getZ()) / 2.0);
            }
            this.level.addFreshEntity((Entity)buried);
            buried.spawnAnim();
        }
        super.brushingCompleted(player);
    }
}

