/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.entity.MooseAI;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.entities.NMLEntityDataSerializers;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;

public class Moose
extends Animal {
    private static final EntityDataAccessor<Integer> DATA_PACIFICATION_STAGE = SynchedEntityData.defineId(Moose.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<MooseState> MOOSE_STATE = SynchedEntityData.defineId(Moose.class, NMLEntityDataSerializers.MOOSE_STATE.get());
    @Nullable
    private UUID persistentAngerTarget;
    private long inStateTicks = 0L;
    public final AnimationState stompAnimationState = new AnimationState();

    public Moose(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR_TOUGHNESS, (double)0.1f).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public MooseState getState() {
        return (MooseState)((Object)this.entityData.get(MOOSE_STATE));
    }

    public void switchToState(MooseState state) {
        this.entityData.set(MOOSE_STATE, (Object)state);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (MOOSE_STATE.equals(key)) {
            this.inStateTicks = 0L;
        }
        super.onSyncedDataUpdated(key);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomSource = level.getRandom();
        MooseAI.initMemories(this, randomSource);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOOSE_STATE, (Object)MooseState.IDLE);
        builder.define(DATA_PACIFICATION_STAGE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("state", this.getState().getSerializedName());
        compound.putInt("PacificationStage", this.getPacificationStage());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.switchToState(MooseState.fromName(compound.getString("state")));
        if (compound.contains("PacificationStage")) {
            this.setPacificationStage(compound.getInt("PacificationStage"));
        }
    }

    public void beginStomp() {
        if (this.getState() == MooseState.IDLE) {
            this.stopInPlace();
            this.resetLove();
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.switchToState(MooseState.STOMPING);
        }
    }

    public void endStomp() {
        if (this.getState() == MooseState.STOMPING) {
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.switchToState(MooseState.IDLE);
        }
    }

    public boolean shouldEndStomping() {
        return this.getState() == MooseState.STOMPING && (double)this.inStateTicks >= 30.0;
    }

    protected Brain.Provider<Moose> brainProvider() {
        return MooseAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return MooseAI.makeBrain((Brain<Moose>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("mooseBrain");
        this.brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("mooseActivityUpdate");
        MooseAI.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.shouldEndStomping()) {
            this.endStomp();
        }
        ++this.inStateTicks;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        Moose baby = (Moose)NMLEntities.MOOSE.get().create((Level)pLevel);
        if (baby != null && this.isPacified() && ((Moose)pOtherParent).isPacified()) {
            baby.setPacificationStage(5);
        }
        if (baby != null) {
            MooseAI.initMemories(baby, pLevel.getRandom());
        }
        return baby;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (!this.level().isClientSide || this.isBaby() && this.isFood(itemstack)) {
            if (itemstack.is(Items.GOLDEN_CARROT) && this.getPacificationStage() < 5) {
                int pacificationStage = this.getPacificationStage();
                itemstack.consume(1, (LivingEntity)player);
                if (pacificationStage < 4) {
                    this.setPacificationStage(pacificationStage + 1);
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                } else if (this.random.nextInt(3) == 0) {
                    this.setPacificationStage(5);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(player, hand);
        }
        boolean flag = itemstack.is(Items.GOLDEN_CARROT) && this.getPacificationStage() < 5;
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!tamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getPacificationStage() {
        return (Integer)this.entityData.get(DATA_PACIFICATION_STAGE);
    }

    public void setPacificationStage(int stage) {
        this.entityData.set(DATA_PACIFICATION_STAGE, (Object)stage);
    }

    public boolean isPacified() {
        return this.getPacificationStage() == 5;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(NMLTags.MOOSE_FOOD);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.HOGLIN_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.RAVAGER_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.DOLPHIN_DEATH;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.75f : 1.0f;
    }

    private void setupAnimationStates() {
        switch (this.getState().ordinal()) {
            case 0: {
                this.stompAnimationState.stop();
                break;
            }
            case 1: {
                this.stompAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        if (this.isPacified()) {
            return null;
        }
        return this.getTargetFromBrain();
    }

    public static enum MooseState implements StringRepresentable
    {
        IDLE("idle", 0),
        STOMPING("stomping", 1),
        CHARGING("charging", 2);

        private static final StringRepresentable.EnumCodec<MooseState> CODEC;
        private static final IntFunction<MooseState> BY_ID;
        public static final StreamCodec<ByteBuf, MooseState> STREAM_CODEC;
        private final String name;
        private final int id;

        private MooseState(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static MooseState fromName(String name) {
            return (MooseState)CODEC.byName(name, (Enum)IDLE);
        }

        public String getSerializedName() {
            return this.name;
        }

        private int id() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(MooseState::values);
            BY_ID = ByIdMap.continuous(MooseState::id, (Object[])MooseState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, MooseState::id);
        }
    }
}

