/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.entity.Moose;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.entities.NMLMemoryModules;
import com.farcr.nomansland.common.registry.entities.NMLSensors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class MooseAI {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final UniformInt TIME_BETWEEN_ATTACKS = UniformInt.of((int)150, (int)200);
    private static final ImmutableList<SensorType<? extends Sensor<? super Moose>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, NMLSensors.MOOSE_TEMPTATIONS.get(), (Object)SensorType.NEAREST_ADULT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.IS_TEMPTED, MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY, NMLMemoryModules.FIGHT_COOLDOWN_TICKS.get()});

    public static Brain.Provider<Moose> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static void initMemories(Moose moose, RandomSource random) {
        moose.getBrain().setMemory(NMLMemoryModules.FIGHT_COOLDOWN_TICKS.get(), (Object)TIME_BETWEEN_ATTACKS.sample(random));
    }

    protected static Brain<?> makeBrain(Brain<Moose> brain) {
        MooseAI.initCoreActivity(brain);
        MooseAI.initIdleActivity(brain);
        MooseAI.initFightActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Moose> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(NMLMemoryModules.FIGHT_COOLDOWN_TICKS.get())));
    }

    private static void initIdleActivity(Brain<Moose> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove(NMLEntities.MOOSE.get(), 1.0f, 1)), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)1.25f), (Object)1)))), (Object)Pair.of((Object)3, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)4, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initFightActivity(Brain<Moose> brain) {
        brain.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Stomp(moose -> TIME_BETWEEN_ATTACKS)))), (Set)ImmutableSet.of((Object)Pair.of(NMLMemoryModules.FIGHT_COOLDOWN_TICKS.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(Moose moose) {
        moose.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return item -> item.is(NMLTags.MOOSE_FOOD);
    }

    public static class Stomp
    extends Behavior<Moose> {
        private final Function<Moose, UniformInt> getTimeBetweenAttacks;

        public Stomp(Function<Moose, UniformInt> getTimeBetweenAttacks) {
            super(Map.of());
            this.getTimeBetweenAttacks = getTimeBetweenAttacks;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, Moose owner) {
            return this.isPlayerTooClose(owner);
        }

        protected void tick(ServerLevel level, Moose owner, long gameTime) {
            super.tick(level, (LivingEntity)owner, gameTime);
        }

        protected boolean canStillUse(ServerLevel level, Moose entity, long gameTime) {
            return !entity.shouldEndStomping();
        }

        protected void start(ServerLevel level, Moose entity, long gameTime) {
            entity.beginStomp();
        }

        protected void stop(ServerLevel level, Moose entity, long gameTime) {
            if (entity.shouldEndStomping()) {
                entity.endStomp();
            }
            entity.getBrain().setMemory(NMLMemoryModules.FIGHT_COOLDOWN_TICKS.get(), (Object)this.getTimeBetweenAttacks.apply(entity).sample(level.random));
        }

        private boolean isPlayerTooClose(Moose moose) {
            Optional nearbyEntities = moose.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
            if (!nearbyEntities.isPresent()) {
                return false;
            }
            for (LivingEntity entity : (List)nearbyEntities.get()) {
                if (entity instanceof Moose || !(moose.getPosition(0.0f).distanceTo(entity.getPosition(0.0f)) < 5.0)) continue;
                return true;
            }
            return false;
        }
    }
}

