/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.bombs;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.torches.SconceTorchBlock;
import com.farcr.nomansland.common.block.torches.SconceWallTorchBlock;
import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FirebombEntity
extends ThrowableBombEntity {
    private static final float VERTICAL_RESTITUTION = 0.3f;
    private static final float HORIZONTAL_RESTITUTION = 0.4f;

    public FirebombEntity(EntityType<? extends ThrowableBombEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FirebombEntity(LivingEntity livingEntity, Level level) {
        super(NMLEntities.FIREBOMB.get(), livingEntity, level);
    }

    public FirebombEntity(Level level, double x, double y, double z) {
        super(NMLEntities.FIREBOMB.get(), x, y, z, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    private void spawnParticles(ParticleOptions particle, int amount) {
        for (int i = 0; i < amount; ++i) {
            double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            double cos = Math.cos(alpha);
            double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
            double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
            double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
            this.level().addParticle(particle, this.getX(), this.getY(), this.getZ(), xVelocity * 0.6, yVelocity * 0.6, zVelocity * 0.6);
        }
    }

    public void handleEntityEvent(byte b) {
        if (b == 0) {
            this.spawnParticles((ParticleOptions)ParticleTypes.SMOKE, 320);
            for (int i = 0; i < 40; ++i) {
                double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double cos = Math.cos(alpha);
                double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, false, this.getX(), this.getY(), this.getZ(), xVelocity * 0.1, yVelocity * 0.1, zVelocity * 0.1);
            }
        } else if (b == 1) {
            this.spawnParticles((ParticleOptions)ParticleTypes.SMOKE, 400);
        } else {
            super.handleEntityEvent(b);
        }
    }

    @Override
    protected void explode() {
        Level level = this.level();
        level.explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), ((Double)NMLConfig.FIREBOMB_STRENGTH.get()).floatValue(), Level.ExplosionInteraction.NONE);
        BlockPos.withinManhattan((BlockPos)this.blockPosition(), (int)6, (int)4, (int)6).forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            if (state.is(BlockTags.CAMPFIRES) && state.hasProperty((Property)CampfireBlock.LIT) && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (state.getBlock() == Blocks.TNT) {
                TntBlock.explode((Level)level, (BlockPos)pos);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            }
            if (state.getBlock() == NMLBlocks.EXTINGUISHED_TORCH.get()) {
                level.setBlock(pos, Blocks.TORCH.defaultBlockState(), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_WALL_TORCH.get()) {
                level.setBlock(pos, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_SOUL_TORCH.get()) {
                level.setBlock(pos, Blocks.SOUL_TORCH.defaultBlockState(), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_SOUL_WALL_TORCH.get()) {
                level.setBlock(pos, (BlockState)Blocks.SOUL_WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_SCONCE_TORCH.get()) {
                level.setBlock(pos, ((SconceTorchBlock)((Object)((Object)NMLBlocks.SCONCE_TORCH.get()))).defaultBlockState(), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_SCONCE_WALL_TORCH.get()) {
                level.setBlock(pos, (BlockState)((SconceWallTorchBlock)((Object)((Object)NMLBlocks.SCONCE_WALL_TORCH.get()))).defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_SCONCE_SOUL_TORCH.get()) {
                level.setBlock(pos, ((SconceTorchBlock)((Object)((Object)NMLBlocks.SCONCE_SOUL_TORCH.get()))).defaultBlockState(), 3);
            } else if (state.getBlock() == NMLBlocks.EXTINGUISHED_SCONCE_SOUL_WALL_TORCH.get()) {
                level.setBlock(pos, (BlockState)((SconceWallTorchBlock)((Object)((Object)NMLBlocks.SCONCE_SOUL_WALL_TORCH.get()))).defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))), 3);
            }
        });
        level.broadcastEntityEvent((Entity)this, (byte)(this.isInWater() ? 1 : 0));
        this.discard();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide()) {
            this.explode();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 motion = this.getDeltaMovement();
        if (motion.lengthSqr() < 0.1) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setOnGround(true);
            return;
        }
        Direction direction = result.getDirection();
        switch (direction.getAxis()) {
            case X: {
                this.setDeltaMovement(-motion.x() * (double)0.4f, motion.y(), motion.z());
                break;
            }
            case Y: {
                this.setDeltaMovement(motion.x() * (double)0.3f, -motion.y() * (double)0.3f, motion.z() * (double)0.3f);
                break;
            }
            case Z: {
                this.setDeltaMovement(motion.x(), motion.y(), -motion.z() * (double)0.4f);
            }
        }
        if (!this.shouldFuse()) {
            this.startFuse(30);
        }
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.SMOKE;
    }
}

