/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.deer;

import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tazer.mixed_litter.variants.MobVariant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class DeerPatternVariant
extends MobVariant {
    public static final MapCodec<DeerPatternVariant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(v -> v.weight), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").orElse((Object)HolderSet.empty()).forGetter(v -> v.biomes), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(v -> v.texture), (App)ResourceLocation.CODEC.fieldOf("baby_texture").forGetter(v -> v.babyTexture)).apply((Applicative)instance, DeerPatternVariant::new));
    public final int weight;
    public final HolderSet<Biome> biomes;
    public final ResourceLocation texture;
    public final ResourceLocation babyTexture;

    public DeerPatternVariant(int weight, HolderSet<Biome> biomes, ResourceLocation texture, ResourceLocation babyTexture) {
        super(List.of(NMLEntities.DEER.get()));
        this.weight = weight;
        this.biomes = biomes;
        this.texture = texture;
        this.babyTexture = babyTexture;
    }

    public int weight() {
        return this.weight;
    }

    public MobVariant select(LivingEntity entity, LevelAccessor level, List<? extends MobVariant> MobVariants) {
        MobVariant selectedVariant = MobVariants.getFirst();
        ArrayList variants = new ArrayList();
        MobVariants.forEach(MobVariant2 -> {
            if (MobVariant2 instanceof DeerPatternVariant) {
                DeerPatternVariant variant = (DeerPatternVariant)((Object)MobVariant2);
                variants.add(variant);
            }
        });
        List<DeerPatternVariant> defaultVariants = variants.stream().filter(v -> v.biomes.size() == 0).toList();
        List<DeerPatternVariant> biomeVariants = variants.stream().filter(v -> v.biomes.size() > 0 && !v.biomes.contains(level.getBiome(entity.blockPosition()))).toList();
        int cumulativeWeight = 0;
        if (!biomeVariants.isEmpty()) {
            int totalWeight = biomeVariants.stream().mapToInt(v -> v.weight).sum();
            int randomWeight = level.getRandom().nextInt(totalWeight);
            for (DeerPatternVariant variant : biomeVariants) {
                if (randomWeight >= (cumulativeWeight += variant.weight)) continue;
                selectedVariant = variant;
                break;
            }
        } else {
            int totalWeight = defaultVariants.stream().mapToInt(v -> v.weight).sum();
            int randomWeight = level.getRandom().nextInt(totalWeight);
            for (DeerPatternVariant variant : defaultVariants) {
                if (randomWeight >= (cumulativeWeight += variant.weight)) continue;
                selectedVariant = variant;
                break;
            }
        }
        return selectedVariant;
    }

    public MapCodec<? extends MobVariant> codec() {
        return CODEC;
    }
}

