/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.goose;

import com.farcr.nomansland.common.entity.goose.GooseAI;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.entities.NMLEntityDataSerializers;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class Goose
extends PathfinderMob {
    private static final EntityDataAccessor<GooseState> GOOSE_STATE = SynchedEntityData.defineId(Goose.class, NMLEntityDataSerializers.GOOSE_STATE.get());
    private long inStateTicks = 0L;
    public final AnimationState drinkAnimationState = new AnimationState();

    public Goose(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GOOSE_STATE, (Object)GooseState.IDLE);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("State", this.getState().getSerializedName());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.switchToState(GooseState.fromName(compound.getString("State")));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(GOOSE_STATE)) {
            this.inStateTicks = 0L;
        }
        super.onSyncedDataUpdated(key);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected Brain.Provider<Goose> brainProvider() {
        return GooseAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return GooseAI.makeBrain((Brain<Goose>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Goose> getBrain() {
        return super.getBrain();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)NMLSounds.GOOSE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)NMLSounds.GOOSE_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)NMLSounds.GOOSE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound((SoundEvent)NMLSounds.GOOSE_STEP.get(), 0.15f, 1.0f);
    }

    protected void customServerAiStep() {
        ServerLevel level = (ServerLevel)this.level();
        level.getProfiler().push("gooseBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        level.getProfiler().pop();
        level.getProfiler().push("gooseActivityUpdate");
        GooseAI.updateActivity(this);
        level.getProfiler().pop();
        super.customServerAiStep();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        ++this.inStateTicks;
        this.floatGoose();
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        return fluidState.is(FluidTags.WATER);
    }

    private void floatGoose() {
        if (this.isInWater()) {
            CollisionContext collisioncontext = CollisionContext.of((Entity)this);
            if (collisioncontext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.WATER)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new GoosePathNavigation(this, level);
    }

    public PathNavigation getNavigation() {
        return super.getNavigation();
    }

    public void beginDrinking() {
        if (this.getState() == GooseState.IDLE) {
            this.stopInPlace();
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.switchToState(GooseState.DRINKING);
        }
    }

    public void endDrink() {
        if (this.getState() == GooseState.DRINKING) {
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.switchToState(GooseState.IDLE);
        }
    }

    public boolean shouldEndDrinking() {
        return this.getState() == GooseState.DRINKING && (double)this.inStateTicks >= 30.0;
    }

    public GooseState getState() {
        return (GooseState)((Object)this.entityData.get(GOOSE_STATE));
    }

    public void switchToState(GooseState state) {
        this.entityData.set(GOOSE_STATE, (Object)state);
    }

    private void setupAnimationStates() {
        switch (this.getState().ordinal()) {
            case 0: {
                this.drinkAnimationState.stop();
                break;
            }
            case 1: {
                this.drinkAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    public static enum GooseState implements StringRepresentable
    {
        IDLE("idle", 0),
        DRINKING("drinking", 1);

        private static final StringRepresentable.EnumCodec<GooseState> CODEC;
        private static final IntFunction<GooseState> BY_ID;
        public static final StreamCodec<ByteBuf, GooseState> STREAM_CODEC;
        private final String name;
        private final int id;

        private GooseState(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static GooseState fromName(String name) {
            return (GooseState)CODEC.byName(name, (Enum)IDLE);
        }

        public String getSerializedName() {
            return this.name;
        }

        private int id() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(GooseState::values);
            BY_ID = ByIdMap.continuous(GooseState::id, (Object[])GooseState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, GooseState::id);
        }
    }

    public static class GoosePathNavigation
    extends GroundPathNavigation {
        GoosePathNavigation(Goose goose, Level level) {
            super((Mob)goose, level);
        }

        protected PathFinder createPathFinder(int maxVisitedNodes) {
            this.nodeEvaluator = new WalkNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
        }

        protected boolean hasValidPathType(PathType pathType) {
            return pathType == PathType.WATER || super.hasValidPathType(pathType);
        }

        public boolean isStableDestination(BlockPos pos) {
            return this.level.getBlockState(pos).is(Blocks.WATER) || super.isStableDestination(pos);
        }
    }
}

