/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.goose;

import com.farcr.nomansland.common.entity.goose.Goose;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class GooseAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super Goose>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.IS_IN_WATER);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.IS_IN_WATER);

    public static Brain.Provider<Goose> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static Brain<?> makeBrain(Brain<Goose> brain) {
        GooseAI.initCoreActivity(brain);
        GooseAI.initIdleActivity(brain);
        GooseAI.initFloatingActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Goose> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new MoveToTargetSink(500, 700)));
    }

    private static void initIdleActivity(Brain<Goose> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)6.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(5, 20), (Object)2))))));
    }

    private static void initFloatingActivity(Brain<Goose> brain) {
        brain.addActivityWithConditions(Activity.SWIM, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Drinking(60, 200)))), Set.of(Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Goose Goose2) {
        Goose2.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.SWIM, (Object)Activity.IDLE));
    }

    private static class Drinking
    extends Behavior<Goose> {
        Drinking(int minDuration, int maxDuration) {
            super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT), minDuration, maxDuration);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, Goose owner) {
            return true;
        }

        protected boolean canStillUse(ServerLevel level, Goose entity, long gameTime) {
            return !entity.shouldEndDrinking();
        }

        protected void start(ServerLevel level, Goose goose, long gameTime) {
            goose.beginDrinking();
        }

        protected void stop(ServerLevel level, Goose goose, long gameTime) {
            if (goose.shouldEndDrinking()) {
                goose.beginDrinking();
            }
        }
    }
}

