/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.event;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.block.cauldrons.HoneyCauldron;
import com.farcr.nomansland.common.block.cauldrons.MapleSyrupCauldron;
import com.farcr.nomansland.common.block.cauldrons.MilkCauldron;
import com.farcr.nomansland.common.block.cauldrons.ResinCauldron;
import com.farcr.nomansland.common.block.cauldrons.ResinOilCauldron;
import com.farcr.nomansland.common.integration.Mods;
import com.farcr.nomansland.common.recipe.CauldronInteractionInput;
import com.farcr.nomansland.common.recipe.CauldronInteractionRecipe;
import com.farcr.nomansland.common.registry.NMLRecipeSerializers;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.items.NMLItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

@EventBusSubscriber(modid="nomansland")
public class CauldronEvents {
    @SubscribeEvent
    public static void onRightClickBlock(UseItemOnBlockEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        InteractionHand hand = event.getHand();
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.BLOCK && player != null) {
            boolean interacted = false;
            BlockState newState = null;
            if (state.getBlock() instanceof CauldronBlock) {
                if (stack.is(Items.MILK_BUCKET)) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.BUCKET.getDefaultInstance()));
                    interacted = true;
                    newState = (BlockState)((MilkCauldron)((Object)NMLBlocks.MILK_CAULDRON.get())).defaultBlockState().setValue((Property)FourLayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(4));
                    level.setBlockAndUpdate(pos, newState);
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
                } else if (stack.is(Items.HONEY_BOTTLE)) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
                    interacted = true;
                    newState = ((HoneyCauldron)((Object)NMLBlocks.HONEY_CAULDRON.get())).defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                    level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
                } else if (stack.is(NMLItems.MAPLE_SYRUP_BOTTLE)) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
                    interacted = true;
                    newState = ((MapleSyrupCauldron)((Object)NMLBlocks.MAPLE_SYRUP_CAULDRON.get())).defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                    level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
                } else if (stack.is(NMLItems.RESIN_OIL_BOTTLE)) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
                    interacted = true;
                    newState = ((ResinOilCauldron)((Object)NMLBlocks.RESIN_OIL_CAULDRON.get())).defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                    level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
                } else if (stack.is(NMLItems.RESIN) && (player.hasInfiniteMaterials() || stack.getCount() >= 2)) {
                    player.getItemInHand(hand).consume(2, (LivingEntity)player);
                    interacted = true;
                    newState = ((ResinCauldron)((Object)NMLBlocks.RESIN_CAULDRON.get())).defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                    level.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS);
                } else if (Mods.FARMERSDELIGHT.isLoaded() && stack.is(Mods.FARMERSDELIGHT.getItem("milk_bottle"))) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
                    interacted = true;
                    newState = ((MilkCauldron)((Object)NMLBlocks.MILK_CAULDRON.get())).defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                    level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
                }
            } else if (state.getBlock() instanceof LayeredCauldronBlock) {
                RecipeManager recipes = level.getRecipeManager();
                CauldronInteractionInput input = new CauldronInteractionInput(state, stack);
                Optional optional = recipes.getRecipeFor(NMLRecipeSerializers.CAULDRON_INTERACTION_RECIPE.get(), (RecipeInput)input, level);
                Optional<CauldronInteractionRecipe> recipe = optional.map(RecipeHolder::value);
                ItemStack result = recipe.map(r -> r.assemble(input, (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
                int cost = recipe.map(CauldronInteractionRecipe::levelCost).orElse(1);
                if (!result.isEmpty()) {
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
                    int i = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) - cost;
                    newState = i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(i));
                    level.setBlockAndUpdate(pos, newState);
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)result));
                    interacted = true;
                }
            }
            if (interacted) {
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(newState));
                event.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)level.isClientSide));
            }
        }
    }
}

