/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.block.FrostedGrassBlock;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SnowAndFreezeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowAndFreezeFeature.class})
public class SnowAndFreezeFeatureMixin {
    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void place(FeaturePlaceContext<NoneFeatureConfiguration> p_160368_, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel worldgenlevel = p_160368_.level();
        BlockPos blockpos = p_160368_.origin();
        BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableblockpos1 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int k = blockpos.getX() + i;
                int l = blockpos.getZ() + j;
                int i1 = worldgenlevel.getHeight(Heightmap.Types.MOTION_BLOCKING, k, l);
                mutableblockpos.set(k, i1, l);
                mutableblockpos1.set((Vec3i)mutableblockpos).move(Direction.DOWN, 1);
                Biome biome = (Biome)worldgenlevel.getBiome((BlockPos)mutableblockpos).value();
                if (biome.shouldFreeze((LevelReader)worldgenlevel, (BlockPos)mutableblockpos1, false)) {
                    worldgenlevel.setBlock((BlockPos)mutableblockpos1, Blocks.ICE.defaultBlockState(), 2);
                }
                if (!biome.shouldSnow((LevelReader)worldgenlevel, (BlockPos)mutableblockpos)) continue;
                if (worldgenlevel.getBlockState((BlockPos)mutableblockpos).is(NMLBlocks.FROSTED_GRASS.block())) {
                    worldgenlevel.setBlock((BlockPos)mutableblockpos, (BlockState)((FrostedGrassBlock)((Object)NMLBlocks.FROSTED_GRASS.get())).defaultBlockState().setValue((Property)FrostedGrassBlock.SNOWLOGGED, (Comparable)Boolean.valueOf(true)), 2);
                } else {
                    worldgenlevel.setBlock((BlockPos)mutableblockpos, Blocks.SNOW.defaultBlockState(), 2);
                }
                BlockState blockstate = worldgenlevel.getBlockState((BlockPos)mutableblockpos1);
                if (!blockstate.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                worldgenlevel.setBlock((BlockPos)mutableblockpos1, (BlockState)blockstate.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        cir.setReturnValue((Object)true);
    }
}

