/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={VineBlock.class})
public abstract class VineBlockMixin
implements BonemealableBlock {
    @Shadow
    protected abstract boolean canSupportAtFace(BlockGetter var1, BlockPos var2, Direction var3);

    @Redirect(method={"randomTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction;getRandom(Lnet/minecraft/util/RandomSource;)Lnet/minecraft/core/Direction;"))
    private Direction nml$getRandom(RandomSource random) {
        Direction direction = (Direction)Util.getRandom((Object[])Direction.values(), (RandomSource)random);
        while (direction != Direction.DOWN && direction != Direction.UP) {
            direction = (Direction)Util.getRandom((Object[])Direction.values(), (RandomSource)random);
        }
        return direction;
    }

    @Redirect(method={"canSupportAtFace"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z"))
    private boolean nml$isCutVine(BlockState instance, Block block) {
        if (block == NMLBlocks.CUT_VINE.get() && instance.is(Blocks.VINE)) {
            return true;
        }
        if (instance.is(NMLBlocks.CUT_VINE.block())) {
            return false;
        }
        return instance.is(block);
    }

    @Redirect(method={"getUpdatedState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z"))
    private boolean nml$isCutVine1(BlockState instance, Block block) {
        if (block == NMLBlocks.CUT_VINE.get() && instance.is(Blocks.VINE)) {
            return true;
        }
        if (instance.is(NMLBlocks.CUT_VINE.block())) {
            return false;
        }
        return instance.is(block);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        for (BlockPos bp : BlockPos.betweenClosed((int)(x - 3), (int)(y - 3), (int)(z - 3), (int)(x + 3), (int)(y + 3), (int)(z + 3))) {
            BlockState vineState = Blocks.VINE.defaultBlockState();
            if (!serverLevel.getBlockState(bp).isEmpty() || !serverLevel.random.nextBoolean()) continue;
            for (Direction d : Direction.values()) {
                if (d == Direction.DOWN) continue;
                BooleanProperty booleanproperty = VineBlock.getPropertyForFace((Direction)d);
                vineState = (BlockState)vineState.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canSupportAtFace((BlockGetter)serverLevel, bp, d)));
            }
            if (vineState == Blocks.VINE.defaultBlockState()) continue;
            serverLevel.setBlockAndUpdate(bp, vineState);
        }
    }
}

