/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.decorator;

import com.farcr.nomansland.common.registry.worldgen.NMLPondDecoratorTypes;
import com.farcr.nomansland.common.world.feature.decorator.PondDecorator;
import com.farcr.nomansland.common.world.feature.decorator.PondDecoratorType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class StackedPlantPondDecorator
extends PondDecorator {
    public static final MapCodec<StackedPlantPondDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(f -> f.blockProvider), (App)IntProvider.CODEC.fieldOf("cluster_count").forGetter(f -> f.clusterCount), (App)IntProvider.CODEC.fieldOf("cluster_size").forGetter(f -> f.clusterSize), (App)FloatProvider.CODEC.fieldOf("cluster_density").forGetter(f -> f.clusterDensity), (App)IntProvider.CODEC.fieldOf("cluster_spread").forGetter(f -> f.clusterSpread), (App)IntProvider.CODEC.fieldOf("plant_height").forGetter(f -> f.plantHeight)).apply((Applicative)instance, StackedPlantPondDecorator::new));
    protected final BlockStateProvider blockProvider;
    protected final IntProvider clusterCount;
    protected final IntProvider clusterSize;
    protected final FloatProvider clusterDensity;
    protected final IntProvider clusterSpread;
    protected final IntProvider plantHeight;

    public StackedPlantPondDecorator(BlockStateProvider blockProvider, IntProvider clusterCount, IntProvider clusterSize, FloatProvider clusterDensity, IntProvider clusterSpread, IntProvider plantHeight) {
        this.blockProvider = blockProvider;
        this.clusterCount = clusterCount;
        this.clusterSize = clusterSize;
        this.clusterDensity = clusterDensity;
        this.clusterSpread = clusterSpread;
        this.plantHeight = plantHeight;
    }

    @Override
    protected PondDecoratorType<?> type() {
        return (PondDecoratorType)NMLPondDecoratorTypes.STACKED_PLANT.get();
    }

    @Override
    public void place(PondDecorator.Context context) {
        HashSet<BlockPos> excluded = new HashSet<BlockPos>();
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        int count = 0;
        int limit = this.clusterCount.sample(random);
        for (BlockPos pos : Util.shuffledCopy(context.water(), (RandomSource)random)) {
            BlockPos adj;
            if (!excluded.contains(pos) && (adj = this.getAdjacentGround((LevelReader)level, random, pos)) != null) {
                this.placePlant(random, (LevelReader)level, context, adj);
                excluded.add(pos);
                int size = this.clusterSize.sample(random);
                int spread = this.clusterSpread.sample(random);
                float density = this.clusterDensity.sample(random);
                int inClusterCount = 1;
                for (int x = -spread; x <= spread; ++x) {
                    for (int z = -spread; z <= spread; ++z) {
                        BlockPos adj2;
                        if (inClusterCount >= size || !(random.nextFloat() < density) || !this.blockProvider.getState(random, adj2 = adj.offset(x, 0, z)).canSurvive((LevelReader)level, adj2) || !level.getBlockState(adj2).is(BlockTags.REPLACEABLE)) continue;
                        this.placePlant(random, (LevelReader)level, context, adj2);
                        ++inClusterCount;
                    }
                }
                ++count;
            }
            if (count < limit) continue;
            break;
        }
    }

    private BlockPos getAdjacentGround(LevelReader level, RandomSource random, BlockPos pos) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos rel = pos.relative(dir).above();
            if (!this.blockProvider.getState(random, rel).canSurvive(level, rel) || !level.getBlockState(rel).is(BlockTags.REPLACEABLE)) continue;
            validPositions.add(rel);
        }
        if (validPositions.isEmpty()) {
            return null;
        }
        return (BlockPos)validPositions.get(random.nextInt(validPositions.size()));
    }

    private void placePlant(RandomSource random, LevelReader level, PondDecorator.Context context, BlockPos pos) {
        int height = this.plantHeight.sample(random);
        BlockState plantState = this.blockProvider.getState(random, pos);
        for (int i = 0; i < height && level.getBlockState(pos.above(i)).is(BlockTags.REPLACEABLE); ++i) {
            context.setBlock(pos.above(i), plantState);
        }
    }
}

