/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.trunkplacer;

import com.farcr.nomansland.common.registry.worldgen.NMLTrunkPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BranchyTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BranchyTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BranchyTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.codec((int)1, (int)8).fieldOf("branch_count").forGetter(tree -> tree.branchCount), (App)IntProvider.codec((int)1, (int)8).fieldOf("branch_length").forGetter(tree -> tree.branchLength), (App)IntProvider.codec((int)0, (int)8).fieldOf("branch_min_height").forGetter(tree -> tree.branchMinHeight), (App)IntProvider.codec((int)0, (int)8).fieldOf("branch_max_height").forGetter(tree -> tree.branchMaxHeight))).apply((Applicative)instance, BranchyTrunkPlacer::new));
    private final IntProvider branchCount;
    private final IntProvider branchLength;
    private final IntProvider branchMinHeight;
    private final IntProvider branchMaxHeight;

    public BranchyTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider branchCount, IntProvider branchLength, IntProvider branchMinHeight, IntProvider branchMaxHeight) {
        super(baseHeight, heightRandA, heightRandB);
        this.branchCount = branchCount;
        this.branchLength = branchLength;
        this.branchMinHeight = branchMinHeight;
        this.branchMaxHeight = branchMaxHeight;
    }

    protected TrunkPlacerType<?> type() {
        return NMLTrunkPlacerTypes.BRANCHY_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BranchyTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int i = 0; i < freeTreeHeight; ++i) {
            this.placeLog(level, blockSetter, random, pos.above(i), config);
        }
        list.add(new FoliagePlacer.FoliageAttachment(pos.above(freeTreeHeight), 0, false));
        int branchCountSampled = this.branchCount.sample(random);
        int minHeight = this.branchMinHeight.sample(random);
        int maxHeight = freeTreeHeight - this.branchMaxHeight.sample(random);
        for (int i = 0; i < branchCountSampled; ++i) {
            int height = minHeight;
            if (minHeight < maxHeight) {
                height = random.nextIntBetweenInclusive(minHeight, maxHeight);
            }
            Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            BlockPos foliagePos = this.makeLimb(level, blockSetter, random, pos.above(height), this.branchLength.sample(random), dir, config);
            list.add(new FoliagePlacer.FoliageAttachment(foliagePos, 0, false));
        }
        return list;
    }

    private BlockPos makeLimb(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos basePos, int steps, Direction dir, TreeConfiguration config) {
        BlockPos currentBlockPos = basePos.relative(dir);
        BlockPos lastBlockPos = basePos;
        Function<BlockState, BlockState> function = log -> (BlockState)log.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis());
        for (int i = 0; i < steps; ++i) {
            this.placeLog(level, blockSetter, random, currentBlockPos, config, function);
            lastBlockPos = currentBlockPos;
            currentBlockPos = currentBlockPos.relative(dir).relative(dir.getClockWise(), random.nextInt(3) - 1);
        }
        return lastBlockPos.above();
    }
}

