/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.generation;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;

public class NMLBiomePlacements {
    public static void register() {
        if (((Boolean)NMLConfig.MAPLE_BIOMES.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.FOREST, NMLBiomes.MAPLE_FOREST, (double)0.2);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.GROVE, NMLBiomes.MAPLE_GROVE, (double)0.2);
            BiomePlacement.addSubOverworld((ResourceKey)Biomes.GROVE, NMLBiomes.MAPLE_GROVE, (Criterion)CriterionBuilder.alternate(NMLBiomes.MAPLE_FOREST, (ResourceKey)Biomes.FOREST));
            BiomePlacement.addSubOverworld((ResourceKey)Biomes.FOREST, NMLBiomes.MAPLE_FOREST, (Criterion)CriterionBuilder.alternate(NMLBiomes.MAPLE_GROVE, (ResourceKey)Biomes.GROVE));
            BiomePlacement.addSubOverworld(NMLBiomes.MAPLE_FOREST, NMLBiomes.MAPLE_GROVE, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((TagKey)Tags.Biomes.IS_SNOWY), CriterionBuilder.not((Criterion)CriterionBuilder.NEAR_INTERIOR)}));
        }
        if (((Boolean)NMLConfig.FROZEN_WOODS.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.SNOWY_PLAINS, NMLBiomes.FROZEN_WOODS, (double)0.2);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.SNOWY_TAIGA, NMLBiomes.FROZEN_WOODS, (double)0.2);
            BiomePlacement.addSubOverworld((ResourceKey)Biomes.SNOWY_TAIGA, NMLBiomes.FROZEN_WOODS, (Criterion)CriterionBuilder.alternate(NMLBiomes.FROZEN_WOODS, (ResourceKey)Biomes.SNOWY_PLAINS));
            BiomePlacement.addSubOverworld((ResourceKey)Biomes.SNOWY_PLAINS, NMLBiomes.FROZEN_WOODS, (Criterion)CriterionBuilder.alternate(NMLBiomes.FROZEN_WOODS, (ResourceKey)Biomes.SNOWY_TAIGA));
        }
        if (((Boolean)NMLConfig.OLD_GROWTH_FOREST.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.DARK_FOREST, NMLBiomes.OLD_GROWTH_FOREST, (double)0.3);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.OLD_GROWTH_BIRCH_FOREST, NMLBiomes.OLD_GROWTH_FOREST, (double)0.2);
            NMLBiomePlacements.edgeBiome(NMLBiomes.OLD_GROWTH_FOREST, NMLBiomes.OLD_GROWTH_FOREST_EDGE, BiomeParameterTargets.HUMIDITY);
            NMLBiomePlacements.clearingBiome(NMLBiomes.OLD_GROWTH_FOREST, NMLBiomes.OLD_GROWTH_FOREST_CLEARING);
        }
        if (((Boolean)NMLConfig.AUTUMNAL_FOREST.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.FOREST, NMLBiomes.AUTUMNAL_FOREST, (double)0.2);
        }
        if (((Boolean)NMLConfig.BOREAL_FOREST.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.TAIGA, NMLBiomes.BOREAL_FOREST, (double)0.25);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.FOREST, NMLBiomes.BOREAL_FOREST, (double)0.1);
            NMLBiomePlacements.transitionalBiome((ResourceKey<Biome>)Biomes.TAIGA, NMLBiomes.AUTUMNAL_FOREST, NMLBiomes.BOREAL_FOREST);
            NMLBiomePlacements.transitionalBiome(NMLBiomes.DARK_TAIGA, NMLBiomes.AUTUMNAL_FOREST, NMLBiomes.BOREAL_FOREST);
        }
        if (((Boolean)NMLConfig.DARK_TAIGA.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.TAIGA, NMLBiomes.DARK_TAIGA, (double)0.3);
        }
        if (((Boolean)NMLConfig.DARK_SWAMP.get()).booleanValue()) {
            NMLBiomePlacements.transitionalBiome((ResourceKey<Biome>)Biomes.SWAMP, (ResourceKey<Biome>)Biomes.DARK_FOREST, NMLBiomes.DARK_SWAMP);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.DARK_FOREST, NMLBiomes.DARK_SWAMP, (double)0.1);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.SWAMP, NMLBiomes.DARK_SWAMP, (double)0.2);
        }
        if (((Boolean)NMLConfig.BAYOU.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.MANGROVE_SWAMP, NMLBiomes.BAYOU, (double)0.4);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.JUNGLE, NMLBiomes.BAYOU, (double)0.1);
            NMLBiomePlacements.transitionalBiome((ResourceKey<Biome>)Biomes.SWAMP, (ResourceKey<Biome>)Biomes.JUNGLE, NMLBiomes.BAYOU);
        }
        if (((Boolean)NMLConfig.BOG.get()).booleanValue()) {
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.SWAMP, NMLBiomes.BOG, (double)0.2);
            BiomePlacement.replaceOverworld((ResourceKey)Biomes.MANGROVE_SWAMP, NMLBiomes.BOG, (double)0.05);
            BiomePlacement.addSubOverworld((ResourceKey)Biomes.SWAMP, NMLBiomes.BOG, (Criterion)CriterionBuilder.neighbor((ResourceKey)Biomes.PLAINS));
        }
    }

    public static void transitionalBiome(ResourceKey<Biome> mainBiome, ResourceKey<Biome> secondaryBiome, ResourceKey<Biome> transitionalBiome) {
        BiomePlacement.addSubOverworld(mainBiome, transitionalBiome, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor(secondaryBiome), CriterionBuilder.not((Criterion)CriterionBuilder.NEAR_INTERIOR)}));
        BiomePlacement.addSubOverworld(secondaryBiome, transitionalBiome, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.alternate(transitionalBiome, mainBiome), CriterionBuilder.not((Criterion)CriterionBuilder.NEAR_INTERIOR)}));
    }

    public static void edgeBiome(ResourceKey<Biome> interiorBiome, ResourceKey<Biome> edgeBiome, BiomeParameterTargets biomeParameterTarget) {
        BiomePlacement.addSubOverworld(interiorBiome, edgeBiome, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.deviationMin((BiomeParameterTargets)biomeParameterTarget, (float)0.02f), CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.NEAR_BORDER, CriterionBuilder.not((Criterion)CriterionBuilder.NEAR_INTERIOR)}), CriterionBuilder.BEACHSIDE, CriterionBuilder.OCEANSIDE, CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.NEAR_BORDER, CriterionBuilder.neighbor((TagKey)BiomeTags.IS_RIVER)})})}));
    }

    public static void clearingBiome(ResourceKey<Biome> interiorBiome, ResourceKey<Biome> clearingBiome) {
        BiomePlacement.addSubOverworld(interiorBiome, clearingBiome, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.deviationMin((BiomeParameterTargets)BiomeParameterTargets.WEIRDNESS, (float)0.02f), CriterionBuilder.NEAR_INTERIOR, CriterionBuilder.not((Criterion)CriterionBuilder.NEAR_BORDER)}));
    }
}

