/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen.tags;

import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class NMLBiomeTagsProvider
extends BiomeTagsProvider {
    public NMLBiomeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, provider, "nomansland", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(BiomeTags.IS_OVERWORLD).add(new ResourceKey[]{NMLBiomes.AUTUMNAL_FOREST, NMLBiomes.BAYOU, NMLBiomes.BOG, NMLBiomes.DARK_SWAMP, NMLBiomes.DARK_TAIGA, NMLBiomes.BOREAL_FOREST, NMLBiomes.MAPLE_FOREST, NMLBiomes.MAPLE_GROVE, NMLBiomes.FROZEN_WOODS, NMLBiomes.LUSH_RIVER, NMLBiomes.BLACKWATER_RIVER});
        this.tag(BiomeTags.IS_OVERWORLD).addTags(new TagKey[]{NMLTags.OLD_GROWTH_FOREST, NMLTags.CAVES});
        this.addToTags(NMLTags.CAVES, Tags.Biomes.IS_UNDERGROUND, Tags.Biomes.IS_CAVE);
        this.addToTags(NMLBiomes.AUTUMNAL_FOREST, BiomeTags.IS_FOREST, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_TEMPERATE);
        this.addToTags(NMLBiomes.BAYOU, BiomeTags.HAS_SWAMP_HUT, BiomeTags.IS_JUNGLE, Tags.Biomes.IS_SWAMP, Tags.Biomes.IS_DENSE_VEGETATION, Tags.Biomes.IS_HOT, Tags.Biomes.IS_JUNGLE_TREE, Tags.Biomes.IS_WET);
        this.addToTags(NMLBiomes.BOG, BiomeTags.HAS_SWAMP_HUT, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_CONIFEROUS_TREE, Tags.Biomes.IS_COLD, Tags.Biomes.IS_WET, Tags.Biomes.IS_WET_OVERWORLD);
        this.addToTags(NMLBiomes.DARK_SWAMP, BiomeTags.HAS_SWAMP_HUT, BiomeTags.IS_FOREST, Tags.Biomes.IS_SWAMP, Tags.Biomes.IS_DENSE_VEGETATION, Tags.Biomes.IS_SPOOKY, Tags.Biomes.IS_TEMPERATE, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_WET, BiomeTags.HAS_WOODLAND_MANSION);
        this.addToTags(NMLBiomes.DARK_TAIGA, BiomeTags.IS_TAIGA, Tags.Biomes.IS_CONIFEROUS_TREE, Tags.Biomes.IS_COLD, Tags.Biomes.IS_SPOOKY, BiomeTags.HAS_VILLAGE_TAIGA);
        this.addToTags(NMLBiomes.BOREAL_FOREST, BiomeTags.IS_FOREST, Tags.Biomes.IS_CONIFEROUS_TREE, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_TEMPERATE, BiomeTags.HAS_VILLAGE_TAIGA);
        this.addToTags(NMLBiomes.MAPLE_FOREST, BiomeTags.IS_FOREST, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_TEMPERATE);
        this.addToTags(NMLBiomes.MAPLE_GROVE, BiomeTags.IS_FOREST, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_PLATEAU);
        this.addToTags(NMLTags.OLD_GROWTH_FOREST, BiomeTags.IS_FOREST, Tags.Biomes.IS_DECIDUOUS_TREE, Tags.Biomes.IS_DENSE_VEGETATION, Tags.Biomes.IS_TEMPERATE, Tags.Biomes.IS_OLD_GROWTH, Tags.Biomes.IS_RARE);
        this.addToTags(NMLBiomes.FROZEN_WOODS, Tags.Biomes.IS_RARE, Tags.Biomes.IS_CONIFEROUS_TREE, Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, BiomeTags.IS_TAIGA, Tags.Biomes.IS_DEAD, BiomeTags.HAS_IGLOO);
        this.addToTags(NMLBiomes.LUSH_RIVER, BiomeTags.IS_RIVER, BiomeTags.IS_JUNGLE, Tags.Biomes.IS_HOT, Tags.Biomes.IS_DENSE_VEGETATION, Tags.Biomes.IS_JUNGLE_TREE);
        this.addToTags(NMLBiomes.BLACKWATER_RIVER, BiomeTags.IS_RIVER, Tags.Biomes.IS_TEMPERATE, Tags.Biomes.IS_SWAMP, Tags.Biomes.IS_DENSE_VEGETATION);
    }

    @SafeVarargs
    protected final void addToTags(ResourceKey<Biome> biome, TagKey<Biome> ... biomeTags) {
        List.of(biomeTags).forEach(biomeTag -> this.tag((TagKey)biomeTag).add(biome));
    }

    @SafeVarargs
    protected final void addToTags(TagKey<Biome> biome, TagKey<Biome> ... biomeTags) {
        List.of(biomeTags).forEach(biomeTag -> this.tag((TagKey)biomeTag).addTag(biome));
    }
}

