/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.modus;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.shift.msuportmodi.client.gui.modus.BaseSylladexScreen;
import com.shift.msuportmodi.client.gui.tooltip.GristSetTooltip;
import com.shift.msuportmodi.inventory.modus.AlchemyModus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AlchemySylladexScreen
extends BaseSylladexScreen {
    protected ArrayList<AlchemyCard> cards = new ArrayList();

    public AlchemySylladexScreen(Modus modus) {
        super(modus, 19);
    }

    @Override
    public void updateContent() {
        super.updateContent(AlchemyCard::new);
    }

    public void render(GuiGraphics guiGraphics, int xcor, int ycor, float f) {
        super.render(guiGraphics, xcor, ycor, f);
        if (this.isMouseInContainer(xcor, ycor)) {
            int xOffset = (this.width - 256) / 2;
            int yOffset = (this.height - 202) / 2;
            int translX = (int)((float)(xcor - xOffset - 16) * this.scroll);
            int translY = (int)((float)(ycor - yOffset - 17) * this.scroll);
            for (AlchemyCard card : this.cards) {
                if (translX < card.xPos + 2 - this.mapX || translX >= card.xPos + 18 - this.mapX || translY < card.yPos + 7 - this.mapY || translY >= card.yPos + 23 - this.mapY) continue;
                card.drawTooltip(guiGraphics, xcor, ycor);
                break;
            }
        }
    }

    public static class AlchemyCard
    extends SylladexScreen.GuiCard {
        Level level;

        public AlchemyCard(ItemStack item, SylladexScreen gui, int index, int xPos, int yPos) {
            super(item, gui, index, xPos, yPos);
            this.level = Minecraft.getInstance().level;
        }

        protected void drawTooltip(GuiGraphics guiGraphics, int x, int y) {
            if (!this.item.isEmpty()) {
                List tooltip = this.item.getTooltipLines(Item.TooltipContext.of((Level)this.level), (Player)Minecraft.getInstance().player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                GristSet cost = AlchemyModus.getGristCost(this.item, this.level);
                Optional<GristSetTooltip> tooltipComponent = Optional.of(new GristSetTooltip(cost));
                guiGraphics.renderTooltip(this.gui.getMinecraft().font, tooltip, tooltipComponent, x, y);
            }
        }
    }
}

