/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.modus;

import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BaseSylladexScreen
extends SylladexScreen {
    protected Modus modus;
    public static final ResourceLocation CARDTEXTURES = ResourceLocation.fromNamespaceAndPath((String)"msuportmodi", (String)"textures/gui/captcha_cards.png");
    public static final ResourceLocation EXTRAS = ResourceLocation.fromNamespaceAndPath((String)"msuportmodi", (String)"textures/gui/sylladex_icons.png");

    public BaseSylladexScreen(Modus modus, int textureIndex) {
        this.modus = modus;
        this.textureIndex = textureIndex;
    }

    public void updateContent() {
        this.updateContent(SylladexScreen.GuiCard::new);
    }

    public <T extends SylladexScreen.GuiCard> void updateContent(CardFactory<T> factory) {
        NonNullList stacks = this.modus.getItems();
        this.cards.clear();
        this.maxWidth = Math.max(this.mapWidth, 10 + (stacks.size() * 21 + (stacks.size() - 1) * 5));
        this.maxHeight = this.mapHeight;
        super.updateContent();
        int start = Math.max(5, (this.mapWidth - (stacks.size() * 21 + (stacks.size() - 1) * 5)) / 2);
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(factory.create((ItemStack)stacks.get(i), this, i, start + i * 26, (this.mapHeight - 26) / 2));
        }
    }

    public void updatePosition() {
        this.maxWidth = Math.max(this.mapWidth, 10 + (this.cards.size() * 21 + (this.cards.size() - 1) * 5));
        this.maxHeight = this.mapHeight;
        int start = Math.max(5, (this.mapWidth - (this.cards.size() * 21 + (this.cards.size() - 1) * 5)) / 2);
        for (int i = 0; i < this.cards.size(); ++i) {
            SylladexScreen.GuiCard card = (SylladexScreen.GuiCard)this.cards.get(i);
            card.xPos = start + i * 26;
            card.yPos = (this.mapHeight - 26) / 2;
        }
    }

    public ResourceLocation getCardTexture(SylladexScreen.GuiCard card) {
        return CARDTEXTURES;
    }

    public int getCardTextureX(SylladexScreen.GuiCard card) {
        return this.textureIndex % 12 * 21;
    }

    public int getCardTextureY(SylladexScreen.GuiCard card) {
        return (int)Math.floor((double)this.textureIndex / 12.0) * 26;
    }

    protected boolean isMouseInContainer(double xcor, double ycor) {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 202) / 2;
        return xcor >= (double)(xOffset + 16) && xcor < (double)(xOffset + 16 + 224) && ycor >= (double)(yOffset + 17) && ycor < (double)(yOffset + 17 + 153);
    }

    public static interface CardFactory<T extends SylladexScreen.GuiCard> {
        public T create(ItemStack var1, BaseSylladexScreen var2, int var3, int var4, int var5);
    }
}

