/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.modus;

import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.shift.msuportmodi.client.gui.modus.BaseSylladexScreen;
import com.shift.msuportmodi.inventory.modus.CapitalistModus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CapitalistSylladexScreen
extends BaseSylladexScreen {
    protected ArrayList<GuiPricedCard> cards = new ArrayList();
    protected Modus modus;

    public CapitalistSylladexScreen(Modus modus) {
        super(modus, 2);
    }

    @Override
    public void updateContent() {
        super.updateContent(GuiPricedCard::new);
    }

    public void render(GuiGraphics guiGraphics, int xcor, int ycor, float f) {
        super.render(guiGraphics, xcor, ycor, f);
        if (this.isMouseInContainer(xcor, ycor)) {
            int xOffset = (this.width - 256) / 2;
            int yOffset = (this.height - 202) / 2;
            int translX = (int)((float)(xcor - xOffset - 16) * this.scroll);
            int translY = (int)((float)(ycor - yOffset - 17) * this.scroll);
            for (GuiPricedCard card : this.cards) {
                if (translX < card.xPos + 2 - this.mapX || translX >= card.xPos + 18 - this.mapX || translY < card.yPos + 7 - this.mapY || translY >= card.yPos + 23 - this.mapY) continue;
                card.drawTooltip(guiGraphics, xcor, ycor);
                break;
            }
        }
    }

    public static class GuiPricedCard
    extends SylladexScreen.GuiCard {
        public int price;
        Level level;

        public GuiPricedCard(ItemStack item, SylladexScreen gui, int index, int xPos, int yPos) {
            super(item, gui, index, xPos, yPos);
            this.level = Minecraft.getInstance().level;
            this.price = CapitalistModus.getItemPrice(item, this.level);
        }

        protected void drawTooltip(GuiGraphics guiGraphics, int x, int y) {
            if (!this.item.isEmpty()) {
                List tooltip = this.item.getTooltipLines(Item.TooltipContext.of((Level)this.level), (Player)Minecraft.getInstance().player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                tooltip.add(1, Component.literal((String)("Costs " + this.price + " Boondollars to retrieve")).withStyle(ChatFormatting.AQUA));
                guiGraphics.renderTooltip(this.gui.getMinecraft().font, tooltip, Optional.empty(), x, y);
            }
        }
    }
}

