/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.modus;

import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.shift.msuportmodi.client.gui.modus.BaseSylladexScreen;
import com.shift.msuportmodi.inventory.modus.CycloneModus;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class CycloneSylladexScreen
extends BaseSylladexScreen {
    public CycloneSylladexScreen(Modus modus) {
        super(modus, 26);
    }

    @Override
    public void updateContent() {
        NonNullList stacks = this.modus.getItems();
        this.cards.clear();
        this.maxWidth = Math.max(this.mapWidth, 10 + stacks.size() * 13);
        this.maxHeight = Math.max(this.mapWidth, 10 + stacks.size() * 7);
        this.mapX = this.maxWidth / 2 - this.mapWidth / 2;
        this.mapY = this.maxHeight / 2 - this.mapHeight / 2;
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(new CycloneCard((ItemStack)stacks.get(i), this, i, 0, 0));
        }
        this.updatePosition();
    }

    @Override
    public void updatePosition() {
        this.maxWidth = Math.max(this.mapWidth, 10 + this.cards.size() * 13);
        this.maxHeight = Math.max(this.mapWidth, 10 + this.cards.size() * (this.cards.size() >= 25 ? 13 : 7));
        for (int i = 0; i < this.cards.size(); ++i) {
            double angle = (double)((((CycloneModus)this.modus).cyclePosition + (float)i) % (float)this.cards.size()) / (double)this.cards.size() * (Math.PI * 2);
            int centerOffset = 0;
            if (this.cards.size() > 1) {
                centerOffset = this.cards.size() <= 4 ? 26 : (int)(18.0 / Math.sin(Math.PI / (double)this.cards.size()));
            }
            int x = (int)(Math.cos(angle) * (double)centerOffset);
            int y = (int)(Math.sin(angle) * (double)centerOffset);
            SylladexScreen.GuiCard card = (SylladexScreen.GuiCard)this.cards.get(i);
            card.xPos = (this.maxWidth - 26) / 2 + x;
            card.yPos = (this.maxHeight - 26) / 2 + y;
        }
    }

    public boolean canUse(SylladexScreen.GuiCard card) {
        if (this.cards.size() == 1) {
            return true;
        }
        double angleOff = Math.PI * 2 / (double)this.cards.size();
        double cardAngle = this.getCardAngle(card);
        return cardAngle > 4.71238898038469 - angleOff / 2.0 && cardAngle < 4.71238898038469 + angleOff / 2.0;
    }

    public double getCardAngle(SylladexScreen.GuiCard card) {
        int i = this.cards.indexOf(card);
        return (double)((((CycloneModus)this.modus).cyclePosition + (float)i) % (float)this.cards.size()) / (double)this.cards.size() * (Math.PI * 2);
    }

    public int getTextureIndex(SylladexScreen.GuiCard card) {
        return 26 + (this.canUse(card) ? 0 : 1);
    }

    @Override
    public int getCardTextureX(SylladexScreen.GuiCard card) {
        return this.getTextureIndex(card) % 12 * 21;
    }

    @Override
    public int getCardTextureY(SylladexScreen.GuiCard card) {
        return (int)Math.floor((double)this.getTextureIndex(card) / 12.0) * 26;
    }

    public void tick() {
        super.tick();
        this.updatePosition();
    }

    public static class CycloneCard
    extends SylladexScreen.GuiCard {
        public CycloneCard(ItemStack item, SylladexScreen gui, int index, int xPos, int yPos) {
            super(item, gui, index, xPos, yPos);
            this.gui = gui;
        }

        public void onClick(int mouseButton) {
            if (((CycloneSylladexScreen)this.gui).canUse(this) || mouseButton == 1) {
                super.onClick(mouseButton);
            }
        }
    }
}

