/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.modus;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import com.shift.msuportmodi.client.gui.modus.BaseSylladexScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class RouletteSylladexScreen
extends BaseSylladexScreen {
    private ExtendedButton spinButton;
    protected static final ResourceLocation sylladexFrame = ResourceLocation.fromNamespaceAndPath((String)"msuportmodi", (String)"textures/gui/antique_sylladex_frame.png");
    protected static final ResourceLocation greenFabricTexture = ResourceLocation.fromNamespaceAndPath((String)"msuportmodi", (String)"textures/gui/green_fabric.png");
    private boolean isSpinning;
    private float spinSpeed = 0.0f;
    private float spinAngle = 0.0f;

    public RouletteSylladexScreen(Modus modus) {
        super(modus, 53);
    }

    private void spinAction() {
        if (!this.isSpinning && !this.cards.isEmpty()) {
            this.isSpinning = true;
            this.spinSpeed = 0.4f;
            this.spinAngle = (float)(Math.random() * Math.PI * 2.0);
        }
    }

    public void tick() {
        if (this.isSpinning) {
            this.spinAngle += this.spinSpeed;
            this.spinSpeed *= 0.97f;
            if (this.spinSpeed < 0.001f) {
                this.isSpinning = false;
                int selectedIndex = this.getTopCardIndex();
                PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.GetItem(selectedIndex, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.updatePosition();
        }
    }

    public void init() {
        super.init();
        this.spinButton = new ExtendedButton((this.width - 256) / 2 + 15, (this.height - 202) / 2 + 175, 120, 20, (Component)Component.translatable((String)"gui.modus.spin"), button -> this.spinAction());
        this.addRenderableWidget((GuiEventListener)this.spinButton);
    }

    @Override
    public void updateContent() {
        NonNullList stacks = this.modus.getItems();
        this.cards.clear();
        this.maxWidth = Math.max(this.mapWidth, 10 + stacks.size() * 13);
        this.maxHeight = Math.max(this.mapWidth, 10 + stacks.size() * 7);
        this.mapX = this.maxWidth / 2 - this.mapWidth / 2;
        this.mapY = this.maxHeight / 2 - this.mapHeight / 2;
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(new RouletteCard((ItemStack)stacks.get(i), this, i, 0, 0));
        }
        this.updatePosition();
    }

    @Override
    public void updatePosition() {
        this.maxWidth = Math.max(this.mapWidth, 10 + this.cards.size() * 13);
        this.maxHeight = Math.max(this.mapWidth, 10 + this.cards.size() * (this.cards.size() >= 25 ? 13 : 7));
        double radius = this.cards.size() > 1 ? (this.cards.size() <= 4 ? 26.0 : 18.0 / Math.sin(Math.PI / (double)this.cards.size())) : 0.0;
        for (int i = 0; i < this.cards.size(); ++i) {
            double angle = (double)i / (double)this.cards.size() * (Math.PI * 2) + (double)this.spinAngle;
            int x = (int)(Math.cos(angle) * radius);
            int y = (int)(Math.sin(angle) * radius);
            SylladexScreen.GuiCard card = (SylladexScreen.GuiCard)this.cards.get(i);
            card.xPos = (this.maxWidth - 26) / 2 + x;
            card.yPos = (this.maxHeight - 26) / 2 + y;
        }
    }

    public void render(GuiGraphics guiGraphics, int xcor, int ycor, float f) {
        if (this.spinButton != null) {
            this.spinButton.setX((this.width - 256) / 2 + 15);
            this.spinButton.setY((this.height - 202) / 2 + 175);
            this.spinButton.setMessage((Component)Component.translatable((String)(this.isSpinning ? "gui.modus.spinning" : "gui.modus.spin")));
            this.spinButton.active = !this.isSpinning;
        }
        super.render(guiGraphics, xcor, ycor, f);
    }

    public void drawGuiMap(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.blit(greenFabricTexture, 0, 0, 0, 0, this.mapWidth, this.mapHeight);
    }

    protected void renderMenuBackground(GuiGraphics guiGraphics) {
        super.renderMenuBackground(guiGraphics);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 202) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(sylladexFrame, xOffset, yOffset, 0, 0, 256, 202);
    }

    public int getTopCardIndex() {
        int topCardIndex = 0;
        int minY = ((SylladexScreen.GuiCard)this.cards.getFirst()).yPos;
        for (int i = 0; i < this.cards.size(); ++i) {
            if (((SylladexScreen.GuiCard)this.cards.get((int)i)).yPos >= minY) continue;
            minY = ((SylladexScreen.GuiCard)this.cards.get((int)i)).yPos;
            topCardIndex = i;
        }
        return topCardIndex;
    }

    public int getTextureIndex(SylladexScreen.GuiCard card) {
        boolean isEven;
        int cardIndex = this.cards.indexOf(card);
        boolean isTop = cardIndex == this.getTopCardIndex();
        boolean bl = isEven = cardIndex % 2 == 0;
        return isEven ? (isTop ? 54 : 53) : (isTop ? 56 : 55);
    }

    @Override
    public int getCardTextureX(SylladexScreen.GuiCard card) {
        return this.getTextureIndex(card) % 12 * 21;
    }

    @Override
    public int getCardTextureY(SylladexScreen.GuiCard card) {
        return (int)Math.floor((double)this.getTextureIndex(card) / 12.0) * 26;
    }

    public static class RouletteCard
    extends SylladexScreen.GuiCard {
        public RouletteCard(ItemStack item, SylladexScreen gui, int index, int xPos, int yPos) {
            super(item, gui, index, xPos, yPos);
        }

        public void onClick(int mouseButton) {
            super.onClick(mouseButton);
        }
    }
}

