/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.player.ClientPlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GristSetTooltipComponent
implements ClientTooltipComponent {
    private final GristSet cost;
    private static final int GRIST_BOARD_WIDTH = 158;

    public GristSetTooltipComponent(GristSet cost) {
        this.cost = cost;
    }

    public int getHeight() {
        if (this.cost == null || this.cost.isEmpty()) {
            return 10;
        }
        int index = 0;
        int row = 0;
        for (GristAmount amount : this.cost.asAmounts()) {
            int haveStrWidth;
            String needStr = GristSetTooltipComponent.addSuffix(amount.amount());
            String haveStr = "(" + GristSetTooltipComponent.addSuffix(0L) + ")";
            int needStrWidth = Minecraft.getInstance().font.width(needStr);
            int lineWidth = needStrWidth + 8 + (haveStrWidth = Minecraft.getInstance().font.width(haveStr)) + 2;
            if (index + lineWidth > (row + 1) * 158) {
                index = ++row * 158;
            }
            index += lineWidth + 6;
            index = Math.min(index, (row + 1) * 158);
        }
        return (row + 1) * 10;
    }

    public int getWidth(@NotNull Font font) {
        if (this.cost == null || this.cost.isEmpty()) {
            String text = this.cost == null ? I18n.get((String)"minestuck.not_alchemizable", (Object[])new Object[0]) : I18n.get((String)"minestuck.free", (Object[])new Object[0]);
            return font.width(text);
        }
        ClientPlayerData.ClientCache cache = ClientPlayerData.getGristCache((ClientPlayerData.CacheSource)ClientPlayerData.CacheSource.PLAYER);
        GristSet playerGrist = cache.set();
        int maxWidth = 0;
        int index = 0;
        int row = 0;
        for (GristAmount amount : this.cost.asAmounts()) {
            int haveStrWidth;
            long need = amount.amount();
            long have = playerGrist.getGrist(amount.type());
            String needStr = GristSetTooltipComponent.addSuffix(need);
            String haveStr = "(" + GristSetTooltipComponent.addSuffix(have) + ")";
            int needStrWidth = font.width(needStr);
            int lineWidth = needStrWidth + 8 + (haveStrWidth = font.width(haveStr)) + 2;
            if (index + lineWidth > (row + 1) * 158) {
                index = ++row * 158;
            }
            int absoluteWidth = index % 158 + lineWidth;
            maxWidth = Math.max(maxWidth, absoluteWidth);
            index += lineWidth + 6;
            index = Math.min(index, (row + 1) * 158);
        }
        return Math.min(maxWidth, 158);
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        if (this.cost == null || this.cost.isEmpty()) {
            String text = this.cost == null ? I18n.get((String)"minestuck.not_alchemizable", (Object[])new Object[0]) : I18n.get((String)"minestuck.free", (Object[])new Object[0]);
            int color = this.cost == null ? 0xFF0000 : 65280;
            guiGraphics.drawString(font, text, pX, pY, color, false);
            return;
        }
        ClientPlayerData.ClientCache cache = ClientPlayerData.getGristCache((ClientPlayerData.CacheSource)ClientPlayerData.CacheSource.PLAYER);
        GristSet playerGrist = cache.set();
        int index = 0;
        for (GristAmount amount : this.cost.asAmounts()) {
            GristType type = amount.type();
            long need = amount.amount();
            long have = playerGrist.getGrist(type);
            int row = index / 158;
            int color = need <= have ? 65280 : 0xFF5555;
            String needStr = GristSetTooltipComponent.addSuffix(need);
            String haveStr = "(" + GristSetTooltipComponent.addSuffix(have) + ")";
            int needOffset = 1;
            int iconSize = 8;
            int haveOffset = 1;
            int needStrWidth = font.width(needStr);
            if (index + needStrWidth + needOffset + iconSize + haveOffset + font.width(haveStr) > (row + 1) * 158) {
                index = ++row * 158;
            }
            int offsetX = pX + index % 158;
            int offsetY = pY + 8 * row;
            guiGraphics.drawString(font, needStr, offsetX + needOffset, offsetY, color, false);
            guiGraphics.drawString(font, haveStr, offsetX + needOffset + needStrWidth + iconSize + haveOffset, offsetY, color, false);
            ResourceLocation icon = type.getIcon();
            if (icon != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(icon, offsetX + needStrWidth + needOffset, offsetY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            }
            index += needStrWidth + 10 + font.width(haveStr);
            index = Math.min(index + 6, (row + 1) * 158);
        }
    }

    public static String addSuffix(long n) {
        if (n < 10000L) {
            return String.valueOf(n);
        }
        if (n < 10000000L) {
            return n / 1000L + "K";
        }
        return n / 1000000L + "M";
    }
}

