/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.client.gui.tooltip;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class WalletEntityTooltipComponent
implements ClientTooltipComponent {
    private final CompoundTag tag;

    public WalletEntityTooltipComponent(CompoundTag tag) {
        this.tag = tag;
    }

    public int getHeight() {
        return 50;
    }

    public int getWidth(Font font) {
        return 50;
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        String id = this.tag.getString("id");
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        LivingEntity entity = (LivingEntity)type.create((Level)level);
        if (entity == null) {
            return;
        }
        entity.setOnGround(true);
        entity.load(this.tag);
        double rotation = (double)System.currentTimeMillis() / 40.0 % 360.0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.toRadians(rotation));
        Vector3f cameraOffset = new Vector3f(0.0f, 0.0f, 0.0f);
        float height = entity.getBbHeight();
        float scale = height > 2.5f ? 40.0f / height : (height < 1.0f ? 20.0f * (1.0f / height) : 20.0f);
        int centerX = pX + this.getWidth(font) / 2;
        int posY = pY + 43;
        guiGraphics.enableScissor(pX, pY - 33, pX + this.getWidth(font), pY + this.getHeight());
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)centerX, (float)posY, (float)scale, (Vector3f)cameraOffset, (Quaternionf)pose, null, (LivingEntity)entity);
        guiGraphics.disableScissor();
    }
}

