/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.entity.entities;

import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCruxiteSlime
extends Slime {
    private static final EntityDataAccessor<Integer> SLIME_COLOR = SynchedEntityData.defineId(EntityCruxiteSlime.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> STORED_ITEM = SynchedEntityData.defineId(EntityCruxiteSlime.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityCruxiteSlime.class);

    public EntityCruxiteSlime(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new SlimeMoveControl(this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SLIME_COLOR, (Object)0);
        builder.define(STORED_ITEM, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.getStoredItem().is(Items.AIR)) {
            tag.put("storedItem", this.getStoredItem().save((HolderLookup.Provider)this.level().registryAccess()));
        }
        tag.putInt("slimeColor", this.getColor());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("storedItem", 10)) {
            CompoundTag item = tag.getCompound("storedItem");
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)item);
            this.entityData.set(STORED_ITEM, (Object)stack);
        }
        this.entityData.set(SLIME_COLOR, (Object)tag.getInt("slimeColor"));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SlimeFloatGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.goalSelector.addGoal(5, (Goal)new SlimeKeepOnJumpingGoal(this));
    }

    public ItemStack getStoredItem() {
        return (ItemStack)this.entityData.get(STORED_ITEM);
    }

    public void setStoredItem(ItemStack v) {
        this.entityData.set(STORED_ITEM, (Object)v);
    }

    public int getColor() {
        return (Integer)this.entityData.get(SLIME_COLOR);
    }

    public void setSlimeColor(int v) {
        this.entityData.set(SLIME_COLOR, (Object)v);
    }

    protected boolean isDealsDamage() {
        return false;
    }

    public void dropItem() {
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getStoredItem());
        this.level().addFreshEntity((Entity)itemEntity);
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        this.setRemoved(pReason);
        if (pReason == Entity.RemovalReason.KILLED) {
            this.gameEvent((Holder)GameEvent.ENTITY_DIE);
            this.dropItem();
        }
    }

    public void setSize(int size, boolean resetHealth) {
        super.setSize(size, resetHealth);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(10.0);
        this.setHealth(this.getMaxHealth());
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * f;
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final EntityCruxiteSlime slime;
        private boolean isAggressive;

        public SlimeMoveControl(EntityCruxiteSlime slime) {
            super((Mob)slime);
            this.slime = slime;
            this.yRot = 180.0f * slime.getYRot() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean aggressive) {
            this.yRot = yRot;
            this.isAggressive = aggressive;
        }

        public void setWantedMovement(double speed) {
            this.speedModifier = speed;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void tick() {
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), this.yRot, 90.0f));
            this.mob.yHeadRot = this.mob.getYRot();
            this.mob.yBodyRot = this.mob.getYRot();
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mob.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mob.onGround()) {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.getJumpControl().jump();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.playSound(this.slime.getJumpSound(), this.slime.getSoundVolume(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.xxa = 0.0f;
                        this.slime.zza = 0.0f;
                        this.mob.setSpeed(0.0f);
                    }
                } else {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                }
            }
        }
    }

    static class SlimeFloatGoal
    extends Goal {
        private final EntityCruxiteSlime slime;

        public SlimeFloatGoal(EntityCruxiteSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slime.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return (this.slime.isInWater() || this.slime.isInLava()) && this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.slime.getRandom().nextFloat() < 0.8f) {
                this.slime.getJumpControl().jump();
            }
            ((SlimeMoveControl)this.slime.getMoveControl()).setWantedMovement(1.2);
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final EntityCruxiteSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(EntityCruxiteSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.slime.getTarget() == null && (this.slime.onGround() || this.slime.isInWater() || this.slime.isInLava() || this.slime.hasEffect(MobEffects.LEVITATION)) && this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public void tick() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.adjustedTickDelay(40 + this.slime.getRandom().nextInt(60));
                this.chosenDegrees = this.slime.getRandom().nextInt(360);
            }
            ((SlimeMoveControl)this.slime.getMoveControl()).setDirection(this.chosenDegrees, false);
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final EntityCruxiteSlime slime;

        public SlimeKeepOnJumpingGoal(EntityCruxiteSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.slime.isPassenger();
        }

        public void tick() {
            ((SlimeMoveControl)this.slime.getMoveControl()).setWantedMovement(1.0);
        }
    }
}

