/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus;

import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.player.GristCache;
import com.shift.msuportmodi.inventory.modus.BaseModus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;

public class AlchemyModus
extends BaseModus {
    public AlchemyModus(ModusType<? extends BaseModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack items) {
        if (this.size <= this.list.size() || items.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((ItemStack)this.list.get(i)).isEmpty() || !AlchemyModus.getGristCost(items, player.level()).isEmpty()) continue;
            this.list.set(i, (Object)items);
            this.markDirty();
            return true;
        }
        if (AlchemyModus.getGristCost(items, player.level()).isEmpty()) {
            return false;
        }
        this.list.add((Object)items);
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.get(id);
        this.markDirty();
        if (AlchemyModus.getGristCost(item, player.level()).isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (asCard) {
            --this.size;
            this.markDirty();
            return CaptchaCardItem.createGhostCard((ItemStack)((ItemStack)this.list.remove(id)), (MinecraftServer)player.server);
        }
        return this.alchemize(item, player);
    }

    public ItemStack alchemize(ItemStack stack, ServerPlayer player) {
        ItemStack item = stack.copy();
        GristSet cost = AlchemyModus.getGristCost(stack, player.level());
        GristCache cache = GristCache.get((ServerPlayer)player);
        if (cache.tryTake(cost, GristHelper.EnumSource.SERVER)) {
            return item;
        }
        return ItemStack.EMPTY;
    }

    public static GristSet getGristCost(ItemStack stack, Level level) {
        return GristCostRecipe.findCostForItem((ItemStack)stack, (GristType)((GristType)GristTypes.BUILD.get()), (boolean)false, (Level)level);
    }
}

