/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.shift.msuportmodi.inventory.modus.BaseModus;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;

public class CapitalistModus
extends BaseModus {
    public CapitalistModus(ModusType<? extends CapitalistModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        int price = 0;
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        PlayerData data = PlayerData.get((PlayerIdentifier)Objects.requireNonNull(IdentifierHandler.encode((Player)player)), (Level)player.level());
        long boondollars = PlayerBoondollars.getBoondollars((PlayerData)data);
        if (id == -1) {
            for (ItemStack item : this.list) {
                price += CapitalistModus.getItemPrice(item, player.level());
            }
            if (boondollars >= (long)(price = (int)((float)price * 0.8f))) {
                PlayerBoondollars.takeBoondollars((PlayerData)data, (long)price);
                player.sendSystemMessage((Component)Component.literal((String)("You spent $" + price + " to retrieve all items. Remaining balance $" + boondollars)));
                for (ItemStack item : this.list) {
                    CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)item);
                }
                this.list.clear();
                this.markDirty();
                return ItemStack.EMPTY;
            }
            player.sendSystemMessage((Component)Component.literal((String)("Not enough Boondollars to retrieve all items. You need $" + price + " to retrieve all items. Your balance: $" + boondollars)));
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        if (asCard) {
            ItemStack item = (ItemStack)this.list.remove(id);
            --this.size;
            this.markDirty();
            return CaptchaCardItem.createCardWithItem((ItemStack)item, (MinecraftServer)player.server);
        }
        ItemStack item = (ItemStack)this.list.get(id);
        this.markDirty();
        price = CapitalistModus.getItemPrice(item, player.level());
        if (boondollars >= (long)price) {
            PlayerBoondollars.takeBoondollars((PlayerData)data, (long)price);
            boondollars = PlayerBoondollars.getBoondollars((PlayerData)data);
            this.list.remove(id);
            player.sendSystemMessage((Component)Component.literal((String)("You spent $" + price + " to retrieve ")).append(item.getDisplayName()).append((Component)Component.literal((String)(". Remaining balance: $" + boondollars))));
            return item;
        }
        player.sendSystemMessage((Component)Component.literal((String)"Not enough Boondollars to retrieve ").append(item.getDisplayName()).append((Component)Component.literal((String)(". You need $" + price + ", your balance: $" + boondollars))));
        return ItemStack.EMPTY;
    }

    public static int getItemPrice(ItemStack item, Level level) {
        if (item.isEmpty()) {
            return 0;
        }
        GristSet gristConversion = GristCostRecipe.findCostForItem((ItemStack)item, (GristType)((GristType)GristTypes.BUILD.get()), (boolean)false, (Level)level);
        int gristCost = 0;
        if (gristConversion != null) {
            for (Map.Entry grist : gristConversion.asMap().entrySet()) {
                gristCost += (int)Math.abs((float)((Long)grist.getValue()).longValue() * ((GristType)grist.getKey()).getValue());
            }
        }
        int count = item.getCount();
        int price = gristCost / count;
        int multiplier = (int)Math.ceil((double)count * 20.0 / 64.0);
        return price * multiplier;
    }
}

