/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.player.ClientPlayerData;
import com.shift.msuportmodi.inventory.modus.modusdata.CommunistModusData;
import com.shift.msuportmodi.network.CommunistRequestPacket;
import com.shift.msuportmodi.network.CommunistUpdatePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;

public class CommunistModus
extends Modus {
    CommunistModusData data;
    protected int size;
    private NonNullList<ItemStack> clientList = NonNullList.create();
    protected boolean changed;

    public CommunistModus(ModusType<? extends CommunistModus> type, LogicalSide side) {
        super(type, side);
    }

    public void initModus(ItemStack itemStack, ServerPlayer player, NonNullList<ItemStack> prev, int size) {
        this.size = size;
        if (player.level().isClientSide) {
            this.changed = true;
            this.data = CommunistModusData.get(player.server);
            this.data.sendUpdateToPlayer(player);
        }
    }

    public boolean putItemStack(ServerPlayer player, ItemStack stack) {
        this.data = CommunistModusData.get(player.server);
        if (this.data.getSize() <= this.data.getList().size() || stack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.data.getList().size(); ++i) {
            if (!((ItemStack)this.data.getList().get(i)).isEmpty()) continue;
            this.data.setItem(i, stack);
            this.markDirty();
            this.data.broadcastUpdate();
            return true;
        }
        this.data.addItem(stack);
        this.markDirty();
        this.data.broadcastUpdate();
        return true;
    }

    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        this.data = CommunistModusData.get(player.server);
        if (id == -2) {
            if (this.data.getList().size() < this.data.getSize()) {
                this.data.setSize(this.data.getSize() - 1);
                this.markDirty();
                this.data.broadcastUpdate();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.data.getList().isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.data.getList()) {
                CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)item);
            }
            this.data.clear();
            this.data.broadcastUpdate();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.data.getList().size()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = this.data.removeItem(id);
        this.markDirty();
        if (asCard) {
            this.data.setSize(this.data.getSize() - 1);
            this.markDirty();
            item = CaptchaCardItem.createCardWithItem((ItemStack)item, (MinecraftServer)player.server);
        }
        this.data.broadcastUpdate();
        return item;
    }

    public void readFromNBT(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (this.side == LogicalSide.SERVER) {
            this.changed = true;
        }
    }

    public CompoundTag writeToNBT(CompoundTag compoundTag, HolderLookup.Provider provider) {
        return compoundTag;
    }

    public NonNullList<ItemStack> getItems() {
        if (this.side == LogicalSide.CLIENT) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CommunistRequestPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return this.clientList;
        }
        return NonNullList.create();
    }

    public boolean increaseSize(ServerPlayer player) {
        this.data = CommunistModusData.get(player.server);
        if ((Integer)MinestuckConfig.SERVER.modusMaxSize.get() > 0 && this.data.getSize() >= (Integer)MinestuckConfig.SERVER.modusMaxSize.get()) {
            return false;
        }
        this.data.setSize(this.data.getSize() + 1);
        this.markDirty();
        this.data.broadcastUpdate();
        return true;
    }

    public boolean canSwitchFrom(Modus modus) {
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public static void updateClientList(CommunistUpdatePacket packet) {
        Modus modus;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (modus = ClientPlayerData.getModus()) instanceof CommunistModus) {
            CommunistModus communistModus = (CommunistModus)modus;
            assert (mc.level != null);
            RegistryAccess provider = mc.level.registryAccess();
            communistModus.setClientListFromTag(packet.items(), (HolderLookup.Provider)provider);
        }
    }

    public void setClientListFromTag(CompoundTag tag, HolderLookup.Provider provider) {
        int size = tag.getInt("size");
        NonNullList newList = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < size; ++i) {
            if (!tag.contains("item" + i, 10)) continue;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("item" + i));
            newList.set(i, (Object)stack);
        }
        this.markDirty();
        this.clientList = newList;
    }
}

