/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class JujuModusData
extends SavedData {
    public static final String ID = "msuportmodicommunist_modus_data";
    private final MinecraftServer mcServer;
    private final Map<String, InventoryData> inventories = new HashMap<String, InventoryData>();

    public JujuModusData(MinecraftServer mcServer) {
        this.mcServer = mcServer;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        for (Map.Entry<String, InventoryData> entry : this.inventories.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("size", entry.getValue().size);
            NonNullList<ItemStack> list = entry.getValue().getItems();
            for (int i = 0; i < list.size(); ++i) {
                tag.put("item" + i, ((ItemStack)list.get(i)).save(provider));
            }
            compoundTag.put(entry.getKey(), (Tag)tag);
        }
        return compoundTag;
    }

    public static JujuModusData load(CompoundTag compoundTag, HolderLookup.Provider provider, MinecraftServer mcServer) {
        JujuModusData data = new JujuModusData(mcServer);
        for (String key : compoundTag.getAllKeys()) {
            CompoundTag tag = compoundTag.getCompound(key);
            int size = tag.getInt("size");
            NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            for (int i = 0; i < size; ++i) {
                if (!tag.contains("item" + i, 10)) continue;
                list.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("item" + i)));
            }
            data.inventories.put(key, new InventoryData(size, (NonNullList<ItemStack>)list));
        }
        return data;
    }

    public static class InventoryData {
        private int size;
        private NonNullList<ItemStack> items;

        public InventoryData() {
            this.size = 0;
            this.items = NonNullList.create();
        }

        public InventoryData(int size) {
            this.size = size;
            this.items = NonNullList.create();
        }

        public InventoryData(int size, NonNullList<ItemStack> items) {
            this.size = size;
            this.items = items;
        }

        public NonNullList<ItemStack> getItems() {
            return this.items;
        }

        public void setItems(NonNullList<ItemStack> items) {
            this.items = items;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

