/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus;

import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.util.ColorHandler;
import com.shift.msuportmodi.entity.MSUEntities;
import com.shift.msuportmodi.entity.entities.EntityCruxiteSlime;
import com.shift.msuportmodi.inventory.modus.BaseModus;
import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.fml.LogicalSide;

public class SlimeModus
extends BaseModus {
    public SlimeModus(ModusType<? extends SlimeModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                SlimeModus.createSlime(player, item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.remove(id);
        this.markDirty();
        if (asCard) {
            --this.size;
            this.markDirty();
            item = CaptchaCardItem.createCardWithItem((ItemStack)item, (MinecraftServer)player.server);
        }
        if (this.side == LogicalSide.SERVER) {
            SlimeModus.createSlime(player, item);
        }
        return ItemStack.EMPTY;
    }

    public static void createSlime(ServerPlayer source, ItemStack stack) {
        if (source.level().isClientSide()) {
            return;
        }
        ServerLevel world = source.serverLevel();
        EntityCruxiteSlime slime = new EntityCruxiteSlime(MSUEntities.CRUXITE_SLIME.get(), (Level)world);
        slime.moveTo(source.getX(), source.getY() + 1.0, source.getZ(), source.getYRot(), source.getXRot());
        slime.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(slime.blockPosition()), MobSpawnType.COMMAND, null);
        slime.setSize(1, true);
        int color = ColorHandler.getColorForPlayer((ServerPlayer)source);
        slime.setSlimeColor(color == -1 ? 10082794 : color);
        Random random = new Random();
        double speed = 0.5;
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double vx = Math.cos(angle) * speed;
        double vz = Math.sin(angle) * speed;
        double vy = 0.2;
        slime.setDeltaMovement(vx, vy, vz);
        slime.setStoredItem(stack);
        world.addFreshEntity((Entity)slime);
    }
}

