/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus;

import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.shift.msuportmodi.inventory.modus.BaseModus;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class WildMagicModus
extends BaseModus {
    private static final float cost = 10.0f;

    public WildMagicModus(ModusType<? extends BaseModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        if (player.getFoodData().getFoodLevel() <= 0) {
            player.sendSystemMessage((Component)Component.literal((String)"You are too exhausted to perform this action."));
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.get(id);
        if (asCard) {
            --this.size;
            this.markDirty();
            this.list.remove(id);
            return CaptchaCardItem.createCardWithItem((ItemStack)item, (MinecraftServer)player.server);
        }
        boolean giveItem = WildMagicModus.wildCardMagic(player);
        if (giveItem) {
            this.list.remove(id);
            this.markDirty();
            return item;
        }
        return ItemStack.EMPTY;
    }

    private static boolean wildCardMagic(ServerPlayer player) {
        float luck = player.getLuck();
        RandomSource random = player.level().getRandom();
        int bound = Math.max(1, 20 - (int)Math.abs(luck));
        int bonus = (int)(luck > 0.0f ? luck : 0.0f);
        int roll = Math.max(0, Math.min(20, random.nextInt(bound) + 1 + bonus));
        player.causeFoodExhaustion(10.0f);
        player.sendSystemMessage((Component)Component.literal((String)("You rolled a " + roll)));
        Holder<MobEffect> effect = null;
        int amp = 1;
        boolean giveItem = false;
        boolean clearEffects = false;
        switch (roll) {
            case 1: 
            case 2: {
                effect = WildMagicModus.getEffectHolder("wither");
                break;
            }
            case 3: {
                effect = WildMagicModus.getEffectHolder("poison");
                amp = 0;
                break;
            }
            case 4: {
                effect = WildMagicModus.getEffectHolder("slowness");
                break;
            }
            case 5: 
            case 6: {
                effect = WildMagicModus.getEffectHolder("slowness");
                giveItem = true;
                break;
            }
            case 9: {
                giveItem = true;
                clearEffects = true;
                break;
            }
            case 7: 
            case 8: {
                clearEffects = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                giveItem = true;
                break;
            }
            case 15: {
                effect = WildMagicModus.getEffectHolder("water_breathing");
                amp = 0;
                giveItem = true;
                break;
            }
            case 16: 
            case 17: {
                effect = WildMagicModus.getEffectHolder("speed");
                giveItem = true;
                break;
            }
            case 18: 
            case 19: {
                effect = WildMagicModus.getEffectHolder("regeneration");
                amp = 2;
                giveItem = true;
                break;
            }
            case 20: {
                effect = WildMagicModus.getEffectHolder("absorption");
                amp = 3;
                giveItem = true;
            }
        }
        if (clearEffects) {
            player.removeAllEffects();
        }
        if (effect != null) {
            int duration = 300;
            if (player.hasEffect(effect)) {
                duration += Objects.requireNonNull(player.getEffect(effect)).getDuration();
            }
            duration = Math.min(duration, 450);
            player.addEffect(new MobEffectInstance(effect, duration, amp));
        }
        return giveItem;
    }

    private static Holder<MobEffect> getEffectHolder(String id) {
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)id);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)rl);
        return BuiltInRegistries.MOB_EFFECT.getHolderOrThrow(key);
    }
}

