/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.inventory.modus.modusdata;

import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.shift.msuportmodi.network.CommunistUpdatePacket;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.network.PacketDistributor;

public class CommunistModusData
extends SavedData {
    public static final String ID = "msuportmodicommunist_modus_data";
    private int size = 5;
    private NonNullList<ItemStack> list = NonNullList.create();
    public final MinecraftServer mcServer;

    public CommunistModusData(MinecraftServer mcServer) {
        this.mcServer = mcServer;
    }

    public static CommunistModusData get(Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            throw new IllegalArgumentException("Attempted to get CommunistData through client");
        }
        return CommunistModusData.get(server);
    }

    public static CommunistModusData get(MinecraftServer mcServer) {
        ServerLevel level = mcServer.overworld();
        DimensionDataStorage storage = level.getDataStorage();
        return (CommunistModusData)storage.computeIfAbsent(CommunistModusData.factory(mcServer), ID);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("size", this.size);
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            ItemStack item = (ItemStack)iter.next();
            tag.put("item" + i, item.save(provider));
        }
        return tag;
    }

    public static CommunistModusData load(CompoundTag tag, HolderLookup.Provider provider, MinecraftServer mcServer) {
        CommunistModusData data = new CommunistModusData(mcServer);
        data.size = tag.getInt("size");
        data.list = NonNullList.create();
        for (int i = 0; i < data.size; ++i) {
            if (!tag.contains("item" + i, 10)) continue;
            data.list.add((Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("item" + i)));
        }
        return data;
    }

    private static SavedData.Factory<CommunistModusData> factory(MinecraftServer mcServer) {
        return new SavedData.Factory(() -> new CommunistModusData(mcServer), (nbt, registries) -> CommunistModusData.load(nbt, registries, mcServer));
    }

    public NonNullList<ItemStack> getList() {
        return this.list;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.setDirty();
    }

    public void setList(NonNullList<ItemStack> list) {
        this.list = list;
        this.setDirty();
    }

    public void setItem(int i, ItemStack item) {
        if (i >= 0 && i < this.list.size()) {
            this.list.set(i, (Object)item);
            this.setDirty();
        }
    }

    public void addItem(ItemStack item) {
        this.list.add((Object)item);
        this.setDirty();
    }

    public void clear() {
        this.list.clear();
        this.setDirty();
    }

    public ItemStack removeItem(int i) {
        if (i >= 0 && i < this.list.size()) {
            ItemStack item = (ItemStack)this.list.remove(i);
            this.setDirty();
            return item;
        }
        return null;
    }

    public static void initializePlayer(ServerPlayer player) {
        CommunistModusData data = CommunistModusData.get(player.server);
        data.sendUpdateToPlayer(player);
    }

    public void sendUpdateToPlayer(ServerPlayer player) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("size", this.size);
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            ItemStack item = (ItemStack)iter.next();
            tag.put("item" + i, item.save((HolderLookup.Provider)this.mcServer.registryAccess()));
        }
        CommunistUpdatePacket packet = new CommunistUpdatePacket(tag);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        Modus modus = CaptchaDeckHandler.getModus((ServerPlayer)player);
        modus.markDirty();
        modus.checkAndResend(player);
    }

    public void broadcastUpdate() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("size", this.size);
        Iterator iter = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            ItemStack item = (ItemStack)iter.next();
            tag.put("item" + i, item.save((HolderLookup.Provider)this.mcServer.registryAccess()));
        }
        CommunistUpdatePacket packet = new CommunistUpdatePacket(tag);
        for (ServerPlayer player : this.mcServer.getPlayerList().getPlayers()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            Modus modus = CaptchaDeckHandler.getModus((ServerPlayer)player);
            modus.markDirty();
            modus.checkAndResend(player);
        }
    }
}

