/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.item.Captchalogue;

import com.shift.msuportmodi.client.gui.tooltip.WalletEntityTooltip;
import com.shift.msuportmodi.item.MSUItemComponents;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class WalletEntityItem
extends Item {
    public WalletEntityItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            WalletEntityItem.spawnEntity(stack, player, level);
        }
    }

    public static Entity getEntity(CompoundTag tag, ItemStack stack, Level level) {
        Entity entity = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)tag.getString("id")))).create(level);
        entity.load(tag);
        return entity;
    }

    public static void spawnEntity(ItemStack stack, Player player, Level level) {
        CompoundTag tag = (CompoundTag)stack.get(MSUItemComponents.STORED_ENTITY);
        if (tag == null || tag.isEmpty()) {
            return;
        }
        Entity entity = WalletEntityItem.getEntity(tag, stack, level);
        entity.moveTo(player.getX(), player.getY(), player.getZ());
        level.addFreshEntity(entity);
        player.getInventory().removeItem(stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        CompoundTag tag = (CompoundTag)stack.get(MSUItemComponents.STORED_ENTITY);
        if (level.isClientSide || tag == null || tag.isEmpty()) {
            return InteractionResult.FAIL;
        }
        Entity entity = WalletEntityItem.getEntity(tag, stack, level);
        BlockPos blockPos = context.getClickedPos();
        entity.absMoveTo((double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        player.getInventory().removeItem(stack);
        return InteractionResult.SUCCESS;
    }

    public Component getName(ItemStack stack) {
        CompoundTag tag = (CompoundTag)stack.get(MSUItemComponents.STORED_ENTITY);
        if (tag != null && tag.contains("id")) {
            String id = tag.getString("id");
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)id));
            return type.getDescription();
        }
        return super.getName(stack);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CompoundTag tag = (CompoundTag)stack.get(MSUItemComponents.STORED_ENTITY);
        if (tag != null && !tag.isEmpty()) {
            return Optional.of(new WalletEntityTooltip(tag));
        }
        return Optional.empty();
    }
}

