/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.network;

import com.mraof.minestuck.advancements.CaptchalogueTrigger;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.block.machine.AlchemiterBlock;
import com.mraof.minestuck.block.machine.CruxtruderBlock;
import com.mraof.minestuck.block.machine.PunchDesignixBlock;
import com.mraof.minestuck.block.machine.TotemLatheBlock;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.network.MSPacket;
import com.shift.msuportmodi.Config;
import com.shift.msuportmodi.MSUPortModi;
import com.shift.msuportmodi.compat.FTBCompat;
import com.shift.msuportmodi.item.MSUItemComponents;
import com.shift.msuportmodi.item.MSUItems;
import com.shift.msuportmodi.util.RaycastUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record WalletCaptchaloguePacket() implements MSPacket.PlayToServer
{
    public static final CustomPacketPayload.Type<WalletCaptchaloguePacket> ID = new CustomPacketPayload.Type(MSUPortModi.id("wallet_captchalogue"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WalletCaptchaloguePacket> STREAM_CODEC = StreamCodec.unit((Object)new WalletCaptchaloguePacket());

    public void execute(IPayloadContext context, ServerPlayer player) {
        if (!this.captchalogueEntity(player)) {
            this.captchalogueBlockEntity(player);
        }
    }

    private boolean captchalogueEntity(ServerPlayer player) {
        LivingEntity living;
        block9: {
            block8: {
                Entity lookedAt = RaycastUtil.getLookedEntity(player, 4.0);
                if (!(lookedAt instanceof LivingEntity)) break block8;
                living = (LivingEntity)lookedAt;
                if (!(lookedAt instanceof Player)) break block9;
            }
            return false;
        }
        if (!FTBCompat.canInteract(player, living.blockPosition(), living)) {
            return false;
        }
        if (((Boolean)Config.SERVER.shouldEntityUseModify.get()).booleanValue() && !FTBCompat.canModify(player, living.blockPosition(), living)) {
            return false;
        }
        EntityType entityType = living.getType();
        String entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).toString();
        List blacklisted = (List)Config.SERVER.blacklistedEntities.get();
        boolean matchesWildcardId = blacklisted.stream().anyMatch(entry -> WalletCaptchaloguePacket.wildCardMatch(entityId, entry));
        if (entityType.is(MSUPortModi.blacklisted) || matchesWildcardId) {
            return false;
        }
        ItemStack stack = WalletCaptchaloguePacket.getEntityItem(living);
        Modus modus = CaptchaDeckHandler.getModus((ServerPlayer)player);
        if (modus == null) {
            return false;
        }
        if (modus.putItemStack(player, stack.copy())) {
            ((CaptchalogueTrigger)MSCriteriaTriggers.CAPTCHALOGUE.get()).trigger(player, modus, stack);
            stack.setCount(0);
            living.discard();
            modus.checkAndResend(player);
            return true;
        }
        return false;
    }

    private boolean captchalogueBlockEntity(ServerPlayer player) {
        PunchDesignixBlock destroyable;
        TotemLatheBlock destroyable2;
        if (!((Boolean)Config.SERVER.canCaptchalogueBlockEntities.get()).booleanValue()) {
            return false;
        }
        BlockPos pos = RaycastUtil.getLookedBlockPos(player, 4.0);
        if (pos == null) {
            return false;
        }
        Level level = player.level();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        BlockEntity be = level.getBlockEntity(pos);
        BlockPos actualPos = pos;
        if (be == null) {
            return false;
        }
        String beId = Objects.requireNonNull(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)be.getType())).toString();
        List blacklistedBEs = (List)Config.SERVER.blacklistedBlockEntities.get();
        boolean matchesPartialId = blacklistedBEs.stream().anyMatch(entry -> WalletCaptchaloguePacket.wildCardMatch(beId, entry));
        if (matchesPartialId) {
            return false;
        }
        if (!FTBCompat.canModify(player, pos)) {
            return false;
        }
        Block block2 = block;
        Objects.requireNonNull(block2);
        Block block3 = block2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlchemiterBlock.class, CruxtruderBlock.class, TotemLatheBlock.class, PunchDesignixBlock.class}, (Object)block3, n)) {
            case 0: {
                AlchemiterBlock destroyable3 = (AlchemiterBlock)block3;
                Optional mainPos = destroyable3.getMainPos(state, pos, (BlockGetter)level);
                if (!mainPos.isPresent()) break;
                actualPos = (BlockPos)mainPos.get();
                be = level.getBlockEntity(actualPos);
                break;
            }
            case 1: {
                CruxtruderBlock destroyable4 = (CruxtruderBlock)block3;
                actualPos = destroyable4.getMainPos(state, pos);
                be = level.getBlockEntity(actualPos);
                break;
            }
            case 2: {
                destroyable2 = (TotemLatheBlock)block3;
                actualPos = destroyable2.getMainPos(state, pos);
                be = level.getBlockEntity(actualPos);
                break;
            }
            case 3: {
                destroyable = (PunchDesignixBlock)block3;
                actualPos = destroyable.getMainPos(state, pos);
                be = level.getBlockEntity(actualPos);
                break;
            }
        }
        if (be == null) {
            return false;
        }
        ItemStack stack = WalletCaptchaloguePacket.getBlockEntityItem(level, actualPos);
        if (stack.isEmpty()) {
            return false;
        }
        Modus modus = CaptchaDeckHandler.getModus((ServerPlayer)player);
        if (modus == null) {
            return false;
        }
        if (modus.putItemStack(player, stack.copy())) {
            BedPart part;
            ((CaptchalogueTrigger)MSCriteriaTriggers.CAPTCHALOGUE.get()).trigger(player, modus, stack);
            stack.setCount(0);
            if (block instanceof BedBlock && (part = (BedPart)state.getValue((Property)BedBlock.PART)) == BedPart.FOOT) {
                Direction facing = (Direction)state.getValue((Property)BedBlock.FACING);
                actualPos = pos.relative(facing);
            }
            Block block4 = block;
            Objects.requireNonNull(block4);
            Block block5 = block4;
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlchemiterBlock.class, CruxtruderBlock.class, TotemLatheBlock.class, PunchDesignixBlock.class}, (Object)block5, n2)) {
                case 0: {
                    destroyable2 = (AlchemiterBlock)block5;
                    destroyable2.destroyFull(state, level, pos);
                    break;
                }
                case 1: {
                    destroyable = (CruxtruderBlock)block5;
                    destroyable.destroyFull(state, level, pos);
                    break;
                }
                case 2: {
                    TotemLatheBlock destroyable5 = (TotemLatheBlock)block5;
                    destroyable5.destroyFull(state, level, pos);
                    break;
                }
                case 3: {
                    PunchDesignixBlock destroyable6 = (PunchDesignixBlock)block5;
                    destroyable6.destroyFull(state, level, pos);
                    break;
                }
                default: {
                    level.removeBlockEntity(actualPos);
                    level.destroyBlock(actualPos, false);
                }
            }
            modus.checkAndResend(player);
            return true;
        }
        return false;
    }

    private static boolean wildCardMatch(String id, String pattern) {
        String regex = pattern.replace(".", "\\.").replace("*", ".*");
        return id.matches("(?i)" + regex);
    }

    public static ItemStack getEntityItem(LivingEntity entity) {
        String entityId = EntityType.getKey((EntityType)entity.getType()).toString();
        CompoundTag tag = new CompoundTag();
        entity.saveWithoutId(tag);
        tag.putString("id", entityId);
        ItemStack stack = new ItemStack((ItemLike)MSUItems.WALLET_ENTITY_ITEM.get());
        stack.set(MSUItemComponents.STORED_ENTITY, (Object)tag);
        return stack;
    }

    public static ItemStack getBlockEntityItem(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        BlockEntity be = level.getBlockEntity(pos);
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        boolean breakable = hardness >= 0.0f && hardness < 50.0f && !(block instanceof AirBlock);
        Item item = block.asItem();
        if (be != null && breakable && item != Items.AIR) {
            ItemStack stack = new ItemStack((ItemLike)item);
            be.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

