/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.util;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastUtil {
    public static Entity getLookedEntity(ServerPlayer player, double range) {
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos;
        Level level = player.level();
        BlockHitResult blockHit = level.clip(new ClipContext(eyePos = player.getEyePosition(1.0f), reachVec = eyePos.add((lookVec = player.getLookAngle()).scale(range)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDist = blockHit.getType() != HitResult.Type.MISS ? blockHit.getLocation().distanceTo(eyePos) : range;
        AABB playerbox = player.getBoundingBox().expandTowards(lookVec.scale(range));
        return level.getEntities((Entity)player, playerbox, e -> e instanceof LivingEntity && e != player).stream().flatMap(e -> e.getBoundingBox().clip(eyePos, reachVec).stream().map(hit -> new AbstractMap.SimpleEntry<Entity, Vec3>((Entity)e, (Vec3)hit))).filter(pair -> eyePos.distanceTo((Vec3)pair.getValue()) < blockDist).min(Comparator.comparingDouble(pair -> eyePos.distanceTo((Vec3)pair.getValue()))).map(Map.Entry::getKey).orElse(null);
    }

    public static BlockPos getLookedBlockPos(ServerPlayer player, double range) {
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos;
        Level level = player.level();
        BlockHitResult blockHit = level.clip(new ClipContext(eyePos = player.getEyePosition(1.0f), reachVec = eyePos.add((lookVec = player.getLookAngle()).scale(range)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (blockHit.getType() == HitResult.Type.BLOCK) {
            return blockHit.getBlockPos();
        }
        return null;
    }
}

