/*
 * Decompiled with CFR 0.152.
 */
package com.shift.msuportmodi.util;

import com.shift.msuportmodi.item.MSUItemComponents;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StoredItemsUtil {
    public static CompoundTag createTagFromList(NonNullList<ItemStack> list, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("size", list.size());
        Iterator iter = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = (ItemStack)iter.next();
            tag.put("item" + i, stack.save(provider));
        }
        return tag;
    }

    public static NonNullList<ItemStack> getListFromTag(CompoundTag tag, HolderLookup.Provider provider) {
        int size = tag.getInt("size");
        NonNullList list = NonNullList.create();
        for (int i = 0; i < size && tag.contains("item" + i, 10); ++i) {
            list.add((Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound("item" + i)).orElseThrow()));
        }
        return list;
    }

    public static ItemStack createItem(ItemStack item, CompoundTag component) {
        item.set(MSUItemComponents.STORED_ITEMS, (Object)component);
        return item;
    }
}

