/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.catalogue.client.IModData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;

public class NeoForgeModData
implements IModData {
    public static final ResourceLocation VERSION_CHECK_ICONS = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/version_check_icons.png");
    private final IModInfo info;
    private final IModData.Type type;
    private final Set<String> dependencies;

    public NeoForgeModData(IModInfo info) {
        this.info = info;
        this.type = NeoForgeModData.analyzeType(info);
        this.dependencies = NeoForgeModData.analyzeDependencies(info);
    }

    @Override
    public IModData.Type getType() {
        return this.type;
    }

    @Override
    public String getModId() {
        return this.info.getModId();
    }

    @Override
    public String getDisplayName() {
        return this.info.getDisplayName();
    }

    @Override
    public String getVersion() {
        return this.info.getVersion().toString();
    }

    @Override
    public String getDescription() {
        return this.info.getDescription();
    }

    @Override
    @Nullable
    public String getItemIcon() {
        String itemIcon = (String)this.info.getModProperties().get("catalogueItemIcon");
        if (itemIcon == null) {
            itemIcon = ((ModInfo)this.info).getConfigElement(new String[]{"itemIcon"}).orElse(null);
        }
        return itemIcon;
    }

    @Override
    @Nullable
    public String getImageIcon() {
        String s;
        Object v = this.info.getModProperties().get("catalogueImageIcon");
        return v instanceof String ? (s = (String)v) : null;
    }

    @Override
    public String getLicense() {
        if (this.info.getModId().equals("minecraft")) {
            return "All Rights Reserved";
        }
        return this.info.getOwningFile().getLicense();
    }

    @Override
    public String getCredits() {
        return this.getConfigString("credits");
    }

    @Override
    @Nullable
    public String getAuthors() {
        if (this.info.getModId().equals("minecraft")) {
            return "Mojang AB";
        }
        return this.getConfigString("authors");
    }

    @Override
    @Nullable
    public String getHomepage() {
        return this.getConfigString("displayURL");
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return this.getConfigString("issueTrackerURL");
    }

    @Override
    @Nullable
    public String getBanner() {
        return this.info.getLogoFile().orElse(null);
    }

    @Override
    @Nullable
    public String getBackground() {
        String s;
        Object v = this.info.getModProperties().get("catalogueBackground");
        return v instanceof String ? (s = (String)v) : null;
    }

    @Override
    public IModData.Update getUpdate() {
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.info);
        if (result.status().shouldDraw()) {
            return new IModData.Update(result.status().isAnimated(), result.url(), result.status().getSheetOffset(), VERSION_CHECK_ICONS);
        }
        return null;
    }

    @Override
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean hasConfig() {
        return IConfigScreenFactory.getForMod((IModInfo)this.info).isPresent();
    }

    @Override
    public boolean isLogoSmooth() {
        return this.info.getLogoBlur();
    }

    @Override
    public boolean isLibrary() {
        return this.info.getModId().equals("neoforge") || this.type != IModData.Type.DEFAULT;
    }

    @Override
    public void openConfigScreen(Screen parent) {
        ModList.get().getModContainerById(this.info.getModId()).flatMap(container -> IConfigScreenFactory.getForMod((IModInfo)this.info).map(f -> f.createScreen(container, parent))).ifPresent(newScreen -> Minecraft.getInstance().setScreen(newScreen));
    }

    @Override
    public void drawUpdateIcon(GuiGraphics graphics, IModData.Update update, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int vOffset = update.animated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
        graphics.blit(update.textures(), x, y, (float)(update.texOffset() * 8), (float)vOffset, 8, 8, 64, 16);
    }

    @Nullable
    private String getConfigString(String key) {
        return ((ModInfo)this.info).getConfigElement(new String[]{key}).map(Object::toString).orElse(null);
    }

    private static IModData.Type analyzeType(IModInfo info) {
        String modId = info.getModId();
        if (modId.startsWith("fabric-") || modId.equals("fabricloader") || modId.equals("mixinextras")) {
            return IModData.Type.LIBRARY;
        }
        return switch (info.getOwningFile().getFile().getType()) {
            default -> throw new MatchException(null, null);
            case IModFile.Type.MOD -> IModData.Type.DEFAULT;
            case IModFile.Type.LIBRARY, IModFile.Type.GAMELIBRARY -> IModData.Type.LIBRARY;
        };
    }

    private static Set<String> analyzeDependencies(IModInfo source) {
        List versions = source.getDependencies();
        return versions.stream().filter(version -> !version.getModId().equals("minecraft") && !version.getModId().equals("neoforge")).map(IModInfo.ModVersion::getModId).collect(Collectors.toUnmodifiableSet());
    }
}

