/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.client.ClientHelper;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.client.screen.DropdownMenuHandler;
import com.mrcrayfish.catalogue.client.screen.MinecraftModData;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import com.mrcrayfish.catalogue.client.screen.widget.DropdownMenu;
import com.mrcrayfish.catalogue.platform.ClientServices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CatalogueModListScreen
extends Screen
implements DropdownMenuHandler {
    private static final Favourites FAVOURITES = new Favourites();
    private static final Comparator<ModListEntry> SORT_ALPHABETICALLY = Comparator.comparing(o -> o.getData().getDisplayName());
    private static final Comparator<ModListEntry> SORT_ALPHABETICALLY_REVERSED = SORT_ALPHABETICALLY.reversed();
    private static final Comparator<ModListEntry> SORT_FAVOURITES_FIRST = Comparator.comparing(ModListEntry::getData, Comparator.comparing(data -> FAVOURITES.has(data.getModId()))).reversed().thenComparing(SORT_ALPHABETICALLY);
    private static final MutableObject<String> OPTION_QUERY = new MutableObject((Object)"");
    private static final MutableBoolean OPTION_HIDE_LIBRARIES = new MutableBoolean(true);
    private static final MutableBoolean OPTION_CONFIGS_ONLY = new MutableBoolean(false);
    private static final MutableBoolean OPTION_UPDATES_ONLY = new MutableBoolean(false);
    private static final MutableBoolean OPTION_FAVOURITES_ONLY = new MutableBoolean(false);
    private static final MutableObject<Comparator<ModListEntry>> OPTION_SORT = new MutableObject(SORT_ALPHABETICALLY);
    private static final ResourceLocation MISSING_BANNER = ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"textures/gui/missing_banner.png");
    private static final ResourceLocation MISSING_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"textures/gui/missing_background.png");
    private static final ImageInfo MISSING_BANNER_INFO = new ImageInfo(MISSING_BANNER, new Dimension(120, 120));
    private static final Map<String, ImageInfo> BANNER_CACHE = new HashMap<String, ImageInfo>();
    private static final Map<String, ImageInfo> IMAGE_ICON_CACHE = new HashMap<String, ImageInfo>();
    private static final Map<String, Item> ITEM_ICON_CACHE = new HashMap<String, Item>();
    private static final Map<String, IModData> CACHED_MODS = new HashMap<String, IModData>();
    private static final Pattern MOD_ID_PATTERN = Pattern.compile("^[a-z][a-z0-9_]{1,63}$");
    private static final Supplier<Pair<Integer, Integer>> COUNTS = Suppliers.memoize(() -> {
        int[] counts = new int[2];
        CACHED_MODS.forEach((modId, data) -> {
            int n = data.isLibrary() ? 1 : 0;
            counts[n] = counts[n] + 1;
        });
        return Pair.of((Object)counts[0], (Object)counts[1]);
    });
    private static final Map<String, SearchFilter> SEARCH_FILTERS = ImmutableMap.builder().put((Object)"dependencies", (Object)new SearchFilter((query, data) -> {
        IModData target = CACHED_MODS.get(query.toLowerCase(Locale.ENGLISH));
        return target != null && target.getDependencies().contains(data.getModId());
    })).put((Object)"dependents", (Object)new SearchFilter((query, data) -> data.getDependencies().contains(query.toLowerCase(Locale.ENGLISH)))).build();
    private static final Style SEARCH_FILTER_KEY = Style.EMPTY.withColor(ChatFormatting.GOLD);
    private static final Style SEARCH_FILTER_VALUE = Style.EMPTY.withColor(ChatFormatting.WHITE);
    private static ResourceLocation cachedBackground;
    private static boolean loaded;
    private final Screen parentScreen;
    private Button optionsButton;
    private EditBox searchTextField;
    private ModList modList;
    private IModData selectedModData;
    private Button modFolderButton;
    private Button configButton;
    private Button websiteButton;
    private Button issueButton;
    private StringList descriptionList;
    private int tooltipYOffset;
    private List<? extends FormattedCharSequence> activeTooltip;
    @Nullable
    private DropdownMenu menu;

    public CatalogueModListScreen(Screen parent) {
        super(CommonComponents.EMPTY);
        this.parentScreen = parent;
        if (!loaded) {
            ClientServices.PLATFORM.getAllModData().forEach(data -> CACHED_MODS.put(data.getModId(), (IModData)data));
            CACHED_MODS.put("minecraft", new MinecraftModData());
            BANNER_CACHE.put("minecraft", new ImageInfo(LogoRenderer.MINECRAFT_LOGO, new Dimension(1024, 256)));
            FAVOURITES.load();
            loaded = true;
        }
    }

    @Override
    public void setMenu(@Nullable DropdownMenu menu) {
        if (this.menu != null && this.menu != menu) {
            this.menu.hide();
        }
        this.menu = menu;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    protected void init() {
        super.init();
        this.searchTextField = new EditBox(this, this.font, 10, 25, 150, 20, CommonComponents.EMPTY){

            public int getInnerWidth() {
                if (this.getValue().startsWith("@")) {
                    return super.getInnerWidth() - 16;
                }
                return super.getInnerWidth();
            }
        };
        this.searchTextField.setFormatter(this::formatQuery);
        this.searchTextField.setMaxLength(128);
        this.searchTextField.setValue((String)OPTION_QUERY.getValue());
        this.searchTextField.setResponder(s -> {
            if (!((String)OPTION_QUERY.getValue()).equals(s)) {
                OPTION_QUERY.setValue(s);
                this.updateSearchFieldSuggestion((String)s);
                this.modList.filterAndUpdateList();
                this.updateSelectedModList();
            }
        });
        this.addWidget((GuiEventListener)this.searchTextField);
        this.modList = new ModList();
        this.modList.setX(10);
        this.modList.setRenderHeader(false, 0);
        this.addWidget((GuiEventListener)this.modList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, btn -> this.minecraft.setScreen(this.parentScreen)).pos(10, this.modList.getBottom() + 8).size(127, 20).build());
        this.modFolderButton = (Button)this.addRenderableWidget((GuiEventListener)new CatalogueIconButton(140, this.modList.getBottom() + 8, 0, 0, onPress -> Util.getPlatform().openFile(ClientServices.PLATFORM.getModDirectory())));
        int padding = 10;
        int contentLeft = this.modList.getRight() + 12 + padding;
        int contentWidth = this.width - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (Button)this.addRenderableWidget((GuiEventListener)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (Component)Component.translatable((String)"catalogue.gui.config"), onPress -> {
            if (this.selectedModData != null) {
                this.selectedModData.openConfigScreen(this);
            }
        }));
        this.configButton.visible = false;
        this.websiteButton = (Button)this.addRenderableWidget((GuiEventListener)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (Component)Component.literal((String)"Website"), onPress -> this.openLink(this.selectedModData.getHomepage())));
        this.websiteButton.visible = false;
        this.issueButton = (Button)this.addRenderableWidget((GuiEventListener)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (Component)Component.literal((String)"Submit Bug"), onPress -> this.openLink(this.selectedModData.getIssueTracker())));
        this.issueButton.visible = false;
        this.descriptionList = new StringList(contentWidth + padding * 2, 50, contentLeft - padding, 130);
        this.descriptionList.setRenderHeader(false, 0);
        this.descriptionList.visible = false;
        this.addWidget((GuiEventListener)this.descriptionList);
        DropdownMenu menu = DropdownMenu.builder(this).setMinItemSize(100, 16).setAlignment(DropdownMenu.Alignment.BELOW_RIGHT).addMenu((Component)Component.translatable((String)"catalogue.gui.filters"), DropdownMenu.builder(this).setMinItemSize(60, 16).setAlignment(DropdownMenu.Alignment.END_TOP).addCheckbox((Component)Component.translatable((String)"catalogue.gui.filters.configs_only"), OPTION_CONFIGS_ONLY, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        }).addCheckbox((Component)Component.translatable((String)"catalogue.gui.filters.updates_only"), OPTION_UPDATES_ONLY, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        }).addCheckbox((Component)Component.translatable((String)"catalogue.gui.filters.favourites"), OPTION_FAVOURITES_ONLY, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        })).addMenu((Component)Component.translatable((String)"catalogue.gui.sort"), DropdownMenu.builder(this).setMinItemSize(60, 16).setAlignment(DropdownMenu.Alignment.END_TOP).addItem((Component)Component.translatable((String)"catalogue.gui.sort.alphabetically"), () -> {
            OPTION_SORT.setValue(SORT_ALPHABETICALLY);
            this.modList.filterAndUpdateList();
        }).addItem((Component)Component.translatable((String)"catalogue.gui.sort.alphabetically_reverse"), () -> {
            OPTION_SORT.setValue(SORT_ALPHABETICALLY_REVERSED);
            this.modList.filterAndUpdateList();
        }).addItem((Component)Component.translatable((String)"catalogue.gui.sort.favourites_first"), () -> {
            OPTION_SORT.setValue(SORT_FAVOURITES_FIRST);
            this.modList.filterAndUpdateList();
        })).addCheckbox((Component)Component.translatable((String)"catalogue.gui.hide_libraries"), OPTION_HIDE_LIBRARIES, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        }).build();
        this.optionsButton = (Button)this.addRenderableWidget((GuiEventListener)new CatalogueIconButton(this.modList.getRight() - 16, 6, 40, 0, 16, 16, btn -> menu.toggle(btn.getRectangle())));
        this.modList.filterAndUpdateList();
        if (this.selectedModData != null) {
            this.setSelectedModData(this.selectedModData);
            this.updateSelectedModList();
            ModListEntry entry = this.modList.getEntryFromInfo(this.selectedModData);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchFieldSuggestion(this.searchTextField.getValue());
    }

    private void openLink(@Nullable String url) {
        if (url != null) {
            Style style = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            this.handleComponentClicked(style);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.drawModList(graphics, mouseX, mouseY, partialTick);
        this.drawModInfo(graphics, mouseX, mouseY, partialTick);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        boolean inMenu = this.menu != null;
        super.render(graphics, inMenu ? -1000 : mouseX, inMenu ? -1000 : mouseY, partialTicks);
        if (((String)OPTION_QUERY.getValue()).startsWith("@")) {
            int iconX = this.searchTextField.getX() + this.searchTextField.getWidth() - 15;
            int iconY = this.searchTextField.getY() + (this.searchTextField.getHeight() - 10) / 2;
            graphics.blit(CatalogueIconButton.TEXTURE, iconX, iconY, 20.0f, 10.0f, 10, 10, 64, 64);
            if (this.menu == null && ClientHelper.isMouseWithin(iconX, iconY, 10, 10, mouseX, mouseY)) {
                this.setActiveTooltip((Component)Component.translatable((String)"catalogue.gui.advanced_search.info"));
            }
        }
        Optional<IModData> optional = Optional.ofNullable(CACHED_MODS.get("catalogue"));
        optional.ifPresent(this::loadAndCacheLogo);
        ImageInfo imageInfo = BANNER_CACHE.get("catalogue");
        if (imageInfo != null) {
            Dimension size = imageInfo.size();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(imageInfo.resource(), 10, 9, 10, 10, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
        }
        if (this.menu != null) {
            this.menu.render(graphics, mouseX, mouseY, partialTicks);
        } else {
            if (ClientHelper.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
                this.setActiveTooltip((Component)Component.translatable((String)"catalogue.gui.info"));
                this.tooltipYOffset = 10;
            }
            if (this.optionsButton.isMouseOver((double)mouseX, (double)mouseY)) {
                this.setActiveTooltip((Component)Component.translatable((String)"catalogue.gui.options"));
                this.tooltipYOffset = 10;
            }
            if (this.modFolderButton.isMouseOver((double)mouseX, (double)mouseY)) {
                this.setActiveTooltip((Component)Component.translatable((String)"catalogue.gui.open_mods_folder"));
            }
        }
        if (this.activeTooltip != null) {
            graphics.renderTooltip(this.font, this.activeTooltip, mouseX, mouseY + this.tooltipYOffset);
            this.tooltipYOffset = 0;
        }
    }

    public void removed() {
        FAVOURITES.save();
    }

    private void updateSelectedModList() {
        ModListEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModData);
        if (selectedEntry != null) {
            this.modList.setSelected((AbstractSelectionList.Entry)selectedEntry);
        }
    }

    private void updateSearchFieldSuggestion(String value) {
        if (value.isEmpty()) {
            this.searchTextField.setSuggestion(Component.translatable((String)"catalogue.gui.search").append((Component)Component.literal((String)"...")).getString());
        } else if (value.startsWith("@")) {
            int end = value.indexOf(":");
            if (end != -1) {
                String type = value.substring(1, end);
                Optional<String> optional = SEARCH_FILTERS.keySet().stream().filter(filter -> filter.startsWith(type.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(String::length));
                if (optional.isPresent()) {
                    int length = type.length();
                    this.searchTextField.setSuggestion(optional.get().substring(length));
                } else {
                    this.searchTextField.setSuggestion("");
                }
            } else {
                this.searchTextField.setSuggestion("");
            }
        } else {
            Optional<IModData> optional = CACHED_MODS.values().stream().filter(data -> data.getDisplayName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(IModData::getDisplayName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getDisplayName();
                this.searchTextField.setSuggestion(displayName.substring(length));
            } else {
                this.searchTextField.setSuggestion("");
            }
        }
    }

    private void drawModList(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.modList.render(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.render(graphics, mouseX, mouseY, partialTicks);
        MutableComponent modsLabel = ClientServices.COMPONENT.createTitle().withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE);
        MutableComponent countLabel = Component.literal((String)("(" + CACHED_MODS.size() + ")")).withStyle(ChatFormatting.GRAY);
        MutableComponent title = Component.empty().append((Component)modsLabel).append(" ").append((Component)countLabel);
        int titleWidth = this.font.width((FormattedText)title);
        int titleLeft = this.modList.getX() + (this.modList.getWidth() - titleWidth) / 2;
        graphics.drawString(this.font, (Component)title, titleLeft, 10, 0xFFFFFF);
        int countLabelWidth = this.font.width((FormattedText)countLabel);
        Objects.requireNonNull(this.font);
        if (ClientHelper.isMouseWithin(titleLeft + titleWidth - countLabelWidth, 10, countLabelWidth, 9, mouseX, mouseY)) {
            Pair<Integer, Integer> counts = COUNTS.get();
            List<FormattedCharSequence> lines = List.of(Component.translatable((String)"catalogue.gui.mod_count", (Object[])new Object[]{counts.getLeft()}).getVisualOrderText(), Component.translatable((String)"catalogue.gui.library_count", (Object[])new Object[]{counts.getRight()}).getVisualOrderText());
            this.setActiveTooltip(lines);
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int listRight = this.modList.getRight();
        graphics.vLine(listRight + 11, -1, this.height, -9408400);
        graphics.fill(listRight + 12, 0, this.width, this.height, 0x66000000);
        this.descriptionList.render(graphics, mouseX, mouseY, partialTicks);
        int contentLeft = listRight + 12 + 10;
        int contentWidth = this.width - contentLeft - 10;
        if (this.selectedModData != null) {
            String authors;
            String credits;
            this.drawBackground(graphics, this.width - contentLeft + 10, listRight + 12, 0);
            this.drawBanner(graphics, contentWidth, contentLeft, 10, this.width - (listRight + 12 + 10) - 10, 50);
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)contentLeft, 70.0f, 0.0f);
            poseStack.scale(2.0f, 2.0f, 2.0f);
            graphics.drawString(this.font, this.selectedModData.getDisplayName(), 0, 0, 0xFFFFFF);
            poseStack.popPose();
            MutableComponent modId = Component.literal((String)("Mod ID: " + this.selectedModData.getModId())).withStyle(ChatFormatting.DARK_GRAY);
            int modIdWidth = this.font.width((FormattedText)modId);
            graphics.drawString(this.font, (Component)modId, contentLeft + contentWidth - modIdWidth, 92, 0xFFFFFF);
            this.drawStringWithLabel(graphics, "catalogue.gui.version", this.selectedModData.getVersion().toString(), contentLeft, 92, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            IModData.Update update = this.selectedModData.getUpdate();
            if (update != null && update.url() != null && !update.url().isBlank()) {
                MutableComponent version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion());
                int versionWidth = this.font.width((FormattedText)version);
                this.selectedModData.drawUpdateIcon(graphics, update, contentLeft + versionWidth + 5, 92);
                if (ClientHelper.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    MutableComponent message = ClientServices.COMPONENT.createFormatted("catalogue.gui.update_available", update.url());
                    this.setActiveTooltip((Component)message);
                }
            }
            graphics.fillGradient(listRight + 12, this.height - 50, this.width, this.height, 0, 0x66000000);
            int labelOffset = this.height - 18;
            String license = this.selectedModData.getLicense();
            if (!license.isBlank()) {
                this.drawStringWithLabel(graphics, "catalogue.gui.licenses", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
                labelOffset -= 15;
            }
            if ((credits = this.selectedModData.getCredits()) != null && !credits.isBlank()) {
                this.drawStringWithLabel(graphics, ClientServices.COMPONENT.getCreditsKey(), credits, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
                labelOffset -= 15;
            }
            if ((authors = this.selectedModData.getAuthors()) != null && !authors.isBlank()) {
                this.drawStringWithLabel(graphics, "catalogue.gui.authors", authors, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            }
        } else {
            MutableComponent message = Component.translatable((String)"catalogue.gui.no_selection").withStyle(ChatFormatting.GRAY);
            graphics.drawCenteredString(this.font, (Component)message, contentLeft + contentWidth / 2, this.height / 2 - 5, 0xFFFFFF);
        }
    }

    private void drawStringWithLabel(GuiGraphics graphics, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, ChatFormatting labelColor, ChatFormatting contentColor) {
        MutableComponent formatted = ClientServices.COMPONENT.createFormatted(format, text);
        String rawString = formatted.getString();
        String label = rawString.substring(0, rawString.indexOf(":") + 1);
        Object content = rawString.substring(rawString.indexOf(":") + 1);
        if (this.font.width((FormattedText)formatted) > maxWidth) {
            content = this.font.plainSubstrByWidth((String)content, maxWidth - this.font.width(label) - 7) + "...";
            MutableComponent credits = Component.literal((String)label).withStyle(labelColor);
            credits.append((Component)Component.literal((String)content).withStyle(contentColor));
            graphics.drawString(this.font, (Component)credits, x, y, 0xFFFFFF);
            if (ClientHelper.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip((Component)Component.literal((String)text));
            }
        } else {
            graphics.drawString(this.font, (Component)Component.literal((String)label).withStyle(labelColor).append((Component)Component.literal((String)content).withStyle(contentColor)), x, y, 0xFFFFFF);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        IModData.Update update;
        MutableComponent version;
        int versionWidth;
        int contentLeft;
        if (this.menu != null) {
            if (!this.menu.mouseClicked(mouseX, mouseY, button)) {
                this.setMenu(null);
            }
            return true;
        }
        if (ClientHelper.isMouseWithin(10, 9, 10, 10, (int)mouseX, (int)mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        if (this.selectedModData != null && ClientHelper.isMouseWithin((contentLeft = this.modList.getRight() + 12 + 10) + (versionWidth = this.font.width((FormattedText)(version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion())))) + 5, 92, 8, 8, (int)mouseX, (int)mouseY) && (update = this.selectedModData.getUpdate()) != null && update.url() != null && !update.url().isBlank()) {
            Style style = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, update.url()));
            this.handleComponentClicked(style);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 70 && CatalogueModListScreen.hasControlDown()) {
            if (!this.searchTextField.isFocused()) {
                this.setFocused((GuiEventListener)this.searchTextField);
                this.searchTextField.moveCursorToEnd(false);
                this.searchTextField.setHighlightPos(0);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void setActiveTooltip(Component content) {
        this.activeTooltip = this.font.split((FormattedText)content, Math.min(200, this.width));
        this.tooltipYOffset = 0;
    }

    private void setActiveTooltip(List<? extends FormattedCharSequence> activeTooltip) {
        this.activeTooltip = activeTooltip;
        this.tooltipYOffset = 0;
    }

    private void setSelectedModData(IModData data) {
        this.selectedModData = data;
        this.loadAndCacheLogo(data);
        this.loadAndCacheBackground(data);
        this.configButton.visible = true;
        this.websiteButton.visible = true;
        this.issueButton.visible = true;
        this.configButton.active = data.hasConfig();
        this.websiteButton.active = data.getHomepage() != null;
        this.issueButton.active = data.getIssueTracker() != null;
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.width - contentLeft - 10;
        int labelCount = this.getLabelCount(data);
        this.descriptionList.setWidth(contentWidth);
        this.descriptionList.setHeight(this.height - 135 - labelCount * 15 - 9);
        this.descriptionList.setX(contentLeft);
        this.descriptionList.setTextFromInfo(data);
        this.descriptionList.setScrollAmount(0.0);
    }

    private int getLabelCount(IModData selectedModData) {
        int count = 1;
        if (selectedModData.getCredits() != null && !selectedModData.getCredits().isBlank()) {
            ++count;
        }
        if (selectedModData.getAuthors() != null && !selectedModData.getAuthors().isBlank()) {
            ++count;
        }
        return count;
    }

    private void drawBackground(GuiGraphics graphics, int contentWidth, int x, int y) {
        if (this.selectedModData == null) {
            return;
        }
        ResourceLocation texture = cachedBackground != null ? cachedBackground : MISSING_BACKGROUND;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        builder.addVertex(matrix, (float)x, (float)(y + 128), 0.0f).setUv(0.0f, 1.0f).setColor(0.0f, 0.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, (float)(x + contentWidth), (float)(y + 128), 0.0f).setUv(1.0f, 1.0f).setColor(0.0f, 0.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, (float)(x + contentWidth), (float)y, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawBanner(GuiGraphics graphics, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModData != null) {
            ImageInfo bannerInfo = this.getBanner(this.selectedModData.getModId());
            Dimension size = bannerInfo.size();
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            x += (contentWidth - width) / 2;
            y += (maxHeight - height) / 2;
            if (bannerInfo.resource() == LogoRenderer.MINECRAFT_LOGO) {
                y += 8;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            graphics.blit(bannerInfo.resource(), x, y, width, height, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
            RenderSystem.disableBlend();
        }
    }

    private ImageInfo getBanner(String modId) {
        ImageInfo bannerInfo = BANNER_CACHE.get(modId);
        if (bannerInfo != null) {
            return bannerInfo;
        }
        ImageInfo iconInfo = IMAGE_ICON_CACHE.get(modId);
        if (iconInfo != null) {
            Dimension size = iconInfo.size();
            Dimension newSize = new Dimension(size.width * 10, size.height * 10);
            return new ImageInfo(iconInfo.resource(), newSize);
        }
        return MISSING_BANNER_INFO;
    }

    private void loadAndCacheLogo(IModData data) {
        if (BANNER_CACHE.containsKey(data.getModId())) {
            return;
        }
        BANNER_CACHE.put(data.getModId(), null);
        String banner = data.getBanner();
        if (banner != null && !banner.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), banner, image -> {
                if (image.getWidth() > 1200 || image.getHeight() > 240) {
                    Constants.LOG.warn("Failed to load banner image for {} as it exceeds the maximum size of 1200x240px", (Object)data.getModId());
                    return;
                }
                TextureManager manager = this.minecraft.getTextureManager();
                ResourceLocation resource = manager.register("modlogo", this.createLogoTexture((NativeImage)image, data.isLogoSmooth()));
                Dimension size = new Dimension(image.getWidth(), image.getHeight());
                BANNER_CACHE.put(data.getModId(), new ImageInfo(resource, size));
            });
        }
    }

    private void loadAndCacheIcon(IModData data) {
        if (IMAGE_ICON_CACHE.containsKey(data.getModId())) {
            return;
        }
        IMAGE_ICON_CACHE.put(data.getModId(), null);
        String imageIcon = data.getImageIcon();
        if (imageIcon != null && !imageIcon.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), imageIcon, image -> {
                TextureManager manager = this.minecraft.getTextureManager();
                ResourceLocation resource = manager.register("catalogueicon", this.createLogoTexture((NativeImage)image, data.isLogoSmooth()));
                Dimension size = new Dimension(image.getWidth(), image.getHeight());
                IMAGE_ICON_CACHE.put(data.getModId(), new ImageInfo(resource, size));
            });
            return;
        }
        String logoFile = data.getBanner();
        if (logoFile != null && !logoFile.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), logoFile, image -> {
                if (image.getWidth() != image.getHeight()) {
                    return;
                }
                String modId = data.getModId();
                if (BANNER_CACHE.containsKey(modId) && BANNER_CACHE.get(modId) != null) {
                    IMAGE_ICON_CACHE.put(modId, BANNER_CACHE.get(modId));
                    return;
                }
                TextureManager manager = this.minecraft.getTextureManager();
                DynamicTexture texture = this.createLogoTexture((NativeImage)image, data.isLogoSmooth());
                Dimension size = new Dimension(image.getWidth(), image.getHeight());
                ResourceLocation resource = manager.register("catalogueicon", texture);
                IMAGE_ICON_CACHE.put(modId, new ImageInfo(resource, size));
                BANNER_CACHE.put(modId, new ImageInfo(resource, size));
            });
        }
    }

    private void loadAndCacheBackground(IModData data) {
        if (cachedBackground != null) {
            TextureManager textureManager = this.minecraft.getTextureManager();
            textureManager.release(cachedBackground);
        }
        cachedBackground = null;
        String background = data.getBackground();
        if (background != null && !background.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), background, image -> {
                if (image.getWidth() != 512 || image.getHeight() != 256) {
                    return;
                }
                TextureManager textureManager = this.minecraft.getTextureManager();
                cachedBackground = textureManager.register("cataloguebackground", this.createLogoTexture((NativeImage)image, false));
            });
        }
    }

    private DynamicTexture createLogoTexture(NativeImage image, final boolean smooth) {
        return new DynamicTexture(this, image){

            public void upload() {
                this.bind();
                NativeImage pixels = this.getPixels();
                pixels.upload(0, 0, 0, 0, 0, pixels.getWidth(), pixels.getHeight(), smooth, false, false, false);
            }
        };
    }

    private static boolean performSearchFilter(String query, IModData data) {
        if (!query.startsWith("@")) {
            return false;
        }
        int end = query.indexOf(":");
        if (end == -1) {
            return false;
        }
        String type = query.substring(1, end).toLowerCase(Locale.ENGLISH);
        if (!SEARCH_FILTERS.containsKey(type)) {
            return false;
        }
        String value = query.substring(end + 1);
        return SEARCH_FILTERS.get(type).predicate().test(value, data);
    }

    private FormattedCharSequence formatQuery(String partial, int displayPos) {
        String query = (String)OPTION_QUERY.getValue();
        if (!query.startsWith("@")) {
            return FormattedCharSequence.forward((String)partial, (Style)Style.EMPTY);
        }
        int split = query.indexOf(":");
        if (split == -1) {
            return FormattedCharSequence.forward((String)partial, (Style)SEARCH_FILTER_KEY);
        }
        if (displayPos > split) {
            return FormattedCharSequence.forward((String)partial, (Style)SEARCH_FILTER_VALUE);
        }
        if (displayPos + partial.length() < split) {
            return FormattedCharSequence.forward((String)partial, (Style)SEARCH_FILTER_KEY);
        }
        split = partial.indexOf(":");
        if (split == -1) {
            return FormattedCharSequence.forward((String)partial, (Style)SEARCH_FILTER_KEY);
        }
        return FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)partial.substring(0, split + 1), (Style)SEARCH_FILTER_KEY), (FormattedCharSequence)FormattedCharSequence.forward((String)partial.substring(split + 1), (Style)SEARCH_FILTER_VALUE));
    }

    static {
        loaded = false;
    }

    private record ImageInfo(ResourceLocation resource, Dimension size) {
    }

    private record Dimension(int width, int height) {
    }

    private static class Favourites {
        private final Set<String> mods = new HashSet<String>();
        private boolean needsSave;
        private Path file;

        private Favourites() {
        }

        public void toggle(String modId) {
            if (!this.mods.remove(modId)) {
                this.mods.add(modId);
            }
            this.needsSave = true;
        }

        public boolean has(String modId) {
            return this.mods.contains(modId);
        }

        private void init() {
            try {
                Path configDir = ClientServices.PLATFORM.getConfigDirectory();
                Path file = configDir.resolve("catalogue_favourites.txt");
                if (!Files.exists(file, new LinkOption[0])) {
                    Files.createFile(file, new FileAttribute[0]);
                }
                this.file = file;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void load() {
            try {
                this.init();
                this.mods.clear();
                Predicate<String> modIdRegex = MOD_ID_PATTERN.asMatchPredicate();
                Files.readAllLines(this.file).forEach(s -> {
                    if (modIdRegex.test((String)s) && ClientServices.PLATFORM.isModLoaded((String)s)) {
                        this.mods.add((String)s);
                    }
                });
                this.needsSave = true;
                this.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void save() {
            if (!this.needsSave) {
                return;
            }
            try {
                this.needsSave = false;
                this.init();
                Files.write(this.file, this.mods, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ModList
    extends ObjectSelectionList<ModListEntry> {
        private static final Predicate<IModData> SEARCH_PREDICATE = data -> {
            String query = (String)OPTION_QUERY.getValue();
            if (query.startsWith("@")) {
                return CatalogueModListScreen.performSearchFilter(query, data);
            }
            return data.getDisplayName().toLowerCase(Locale.ENGLISH).contains(query.toLowerCase(Locale.ENGLISH));
        };
        private static final Predicate<IModData> FILTER_PREDICATE = data -> {
            String query = (String)OPTION_QUERY.getValue();
            if (query.startsWith("@")) {
                return true;
            }
            if (OPTION_CONFIGS_ONLY.booleanValue() && !data.hasConfig()) {
                return false;
            }
            if (OPTION_UPDATES_ONLY.booleanValue() && data.getUpdate() == null) {
                return false;
            }
            if (OPTION_HIDE_LIBRARIES.booleanValue() && data.isLibrary()) {
                return false;
            }
            return !OPTION_FAVOURITES_ONLY.booleanValue() || FAVOURITES.has(data.getModId());
        };
        private boolean hideFavourites;

        public ModList() {
            super(CatalogueModListScreen.this.minecraft, 150, CatalogueModListScreen.this.height - 35 - 45, 45, 26);
        }

        public void setRenderHeader(boolean draw, int height) {
            super.setRenderHeader(draw, height);
        }

        protected int getScrollbarPosition() {
            return this.getX() + this.width - 6;
        }

        public int getRowLeft() {
            return this.getX();
        }

        public int getRowRight() {
            return this.getRowLeft() + this.getRowWidth();
        }

        public int getRowWidth() {
            return this.width - (this.scrollbarVisible() ? 6 : 0);
        }

        public void filterAndUpdateList() {
            List entries = CACHED_MODS.values().stream().filter(SEARCH_PREDICATE).filter(FILTER_PREDICATE).map(info -> new ModListEntry((IModData)info, this)).sorted((Comparator)OPTION_SORT.getValue()).collect(Collectors.toList());
            this.replaceEntries(entries);
            this.clampScrollAmount();
        }

        @Nullable
        public ModListEntry getEntryFromInfo(IModData data) {
            return this.children().stream().filter(entry -> entry.data == data).findFirst().orElse(null);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.setColor(0.125f, 0.125f, 0.125f, 1.0f);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            if (this.children().isEmpty()) {
                int left = this.getX() + this.getWidth() / 2;
                int n = this.getY();
                int n2 = this.getHeight();
                Objects.requireNonNull(CatalogueModListScreen.this.font);
                int top = n + (n2 - 9) / 2;
                graphics.drawCenteredString(CatalogueModListScreen.this.font, (Component)Component.translatable((String)"catalogue.gui.no_mods"), left, top, -1);
            }
        }

        protected void renderListSeparators(GuiGraphics graphics) {
        }

        protected void renderSelection(GuiGraphics graphics, int rowTop, int rowStart, int rowBottom, int outlineColour, int backgroundColour) {
            graphics.fill(this.getRowLeft(), rowTop - 2, this.getRowRight(), rowTop + rowBottom + 2, outlineColour);
            graphics.fill(this.getRowLeft() + 1, rowTop - 1, this.getRowRight() - 1, rowTop + rowBottom + 1, backgroundColour);
        }

        public boolean keyPressed(int key, int scanCode, int modifiers) {
            if (key == 257 && this.getSelected() != null) {
                CatalogueModListScreen.this.setSelectedModData(((ModListEntry)this.getSelected()).data);
                SoundManager handler = Minecraft.getInstance().getSoundManager();
                handler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            return super.keyPressed(key, scanCode, modifiers);
        }

        protected boolean isValidMouseClick(int button) {
            return button == 0 || button == 1;
        }

        public void centerScrollOn(ModListEntry entry) {
            super.centerScrollOn((AbstractSelectionList.Entry)entry);
        }

        protected void updateScrollingState(double mouseX, double mouseY, int button) {
            super.updateScrollingState(mouseX, mouseY, button);
            this.hideFavourites = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseY < (double)(this.getScrollbarPosition() + 6);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.hideFavourites && button == 0) {
                this.hideFavourites = false;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }

        public boolean shouldHideFavourites() {
            return this.hideFavourites;
        }
    }

    private class StringList
    extends AbstractSelectionList<StringEntry> {
        private String description;

        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.minecraft, width, height, top, 10);
            this.description = "";
            this.setX(left);
            this.setY(top);
        }

        public void setTextFromInfo(IModData data) {
            this.description = data.getDescription();
            this.clearEntries();
            this.visible = true;
            if (data.getDescription().trim().isBlank()) {
                this.visible = false;
                return;
            }
            CatalogueModListScreen.this.font.getSplitter().splitLines(data.getDescription().trim(), this.getRowWidth(), Style.EMPTY).forEach(text -> this.addEntry((AbstractSelectionList.Entry)new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void setRenderHeader(boolean draw, int height) {
            super.setRenderHeader(draw, height);
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int getScrollbarPosition() {
            return this.getX() + this.width - 7;
        }

        public int getRowLeft() {
            return this.getX() + 8;
        }

        public int getRowWidth() {
            return this.width - 16;
        }

        protected int getRowTop(int $$0) {
            return super.getRowTop($$0) + 4;
        }

        public int getMaxScroll() {
            return Math.max(0, this.getMaxPosition() - (this.height - 12));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            graphics.disableScissor();
        }

        protected void renderListBackground(GuiGraphics graphics) {
            int x = this.getX();
            int y = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.fill(x, y + 1, x + 1, y + height - 1, 0x77000000);
            graphics.fill(x + 1, y, x + width - 1, y + height, 0x77000000);
            graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, 0x77000000);
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
            output.add(NarratedElementType.TITLE, (Component)Component.literal((String)this.description));
        }
    }

    private class ModListEntry
    extends ObjectSelectionList.Entry<ModListEntry> {
        private final IModData data;
        private final ModList list;
        private final PinnedButton button;
        private ItemStack icon;

        public ModListEntry(IModData data, ModList list) {
            this.data = data;
            this.list = list;
            this.button = new PinnedButton(data.getModId());
            this.icon = new ItemStack((ItemLike)this.getItemIcon());
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean inOptionsMenu = CatalogueModListScreen.this.menu != null;
            boolean drawFavouriteIcon = !inOptionsMenu && !this.list.shouldHideFavourites() && ClientHelper.isMouseWithin(left + rowWidth - rowHeight - 4, top, rowHeight + 4, rowHeight, mouseX, mouseY) || FAVOURITES.has(this.data.getModId());
            graphics.drawString(CatalogueModListScreen.this.font, this.getFormattedModName(drawFavouriteIcon), left + 24, top + 2, 0xFFFFFF);
            graphics.drawString(CatalogueModListScreen.this.font, (Component)Component.literal((String)this.data.getVersion()).withStyle(ChatFormatting.GRAY), left + 24, top + 12, 0xFFFFFF);
            this.drawIcon(graphics, top, left);
            IModData.Update update = this.data.getUpdate();
            if (update != null) {
                int iconLeft = left + rowWidth - 8 - 9 + (drawFavouriteIcon ? -14 : 0);
                this.data.drawUpdateIcon(graphics, update, iconLeft, top + 7);
            }
            if (drawFavouriteIcon) {
                this.button.setX(left + rowWidth - this.button.getWidth() - 8);
                this.button.setY(top + (rowHeight - this.button.getHeight()) / 2);
                this.button.render(graphics, mouseX, mouseY, partialTicks);
                if (!inOptionsMenu && this.button.isMouseOver(mouseX, mouseY)) {
                    MutableComponent label = !FAVOURITES.has(this.data.getModId()) ? Component.translatable((String)"catalogue.gui.favourite") : Component.translatable((String)"catalogue.gui.remove_favourite");
                    CatalogueModListScreen.this.setActiveTooltip((Component)label);
                }
            }
        }

        private void drawIcon(GuiGraphics graphics, int top, int left) {
            CatalogueModListScreen.this.loadAndCacheIcon(this.data);
            ImageInfo iconInfo = IMAGE_ICON_CACHE.get(this.data.getModId());
            if (iconInfo != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                Dimension size = iconInfo.size();
                graphics.blit(iconInfo.resource(), left + 4, top + 3, 16, 16, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
                RenderSystem.disableBlend();
                return;
            }
            try {
                graphics.renderFakeItem(this.icon, left + 4, top + 3);
            }
            catch (Exception e) {
                Constants.LOG.debug("Failed to draw icon for mod '{}'", (Object)this.data.getModId());
                ITEM_ICON_CACHE.put(this.data.getModId(), Items.GRASS_BLOCK);
                this.icon = new ItemStack((ItemLike)Items.GRASS_BLOCK);
            }
        }

        private Item getItemIcon() {
            Item item2;
            ResourceLocation resource;
            if (ITEM_ICON_CACHE.containsKey(this.data.getModId())) {
                return ITEM_ICON_CACHE.get(this.data.getModId());
            }
            ITEM_ICON_CACHE.put(this.data.getModId(), Items.GRASS_BLOCK);
            if (this.data.getModId().equals("forge")) {
                Item item3 = Items.ANVIL;
                ITEM_ICON_CACHE.put("forge", item3);
                return item3;
            }
            String itemIcon = this.data.getItemIcon();
            if (itemIcon != null && !itemIcon.isEmpty() && (resource = ResourceLocation.tryParse((String)itemIcon)) != null && (item2 = (Item)BuiltInRegistries.ITEM.get(resource)) != null && item2 != Items.AIR) {
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            Optional<Item> optional = BuiltInRegistries.ITEM.stream().filter(item -> item.builtInRegistryHolder().key().location().getNamespace().equals(this.data.getModId())).findFirst();
            if (optional.isPresent() && (item2 = optional.get()) != Items.AIR) {
                if (ClientServices.PLATFORM.isCustomItemRendering(item2)) {
                    ITEM_ICON_CACHE.put(this.data.getModId(), Items.GRASS_BLOCK);
                    return Items.GRASS_BLOCK;
                }
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            return Items.GRASS_BLOCK;
        }

        private Component getFormattedModName(boolean favouriteIconVisible) {
            Object name = this.data.getDisplayName();
            int paddingEnd = 4;
            int trimWidth = this.list.getRowWidth() - 24 - paddingEnd;
            IModData.Update update = this.data.getUpdate();
            if (update != null) {
                trimWidth -= 12;
            }
            if (favouriteIconVisible) {
                trimWidth -= 18;
            }
            if (CatalogueModListScreen.this.font.width((String)name) > trimWidth) {
                name = CatalogueModListScreen.this.font.plainSubstrByWidth((String)name, trimWidth - 8).trim() + "...";
            }
            MutableComponent title = Component.literal((String)name);
            if (this.data.isLibrary()) {
                title.withStyle(ChatFormatting.DARK_GRAY);
            }
            return title;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.button.mouseClicked(mouseX, mouseY, button)) {
                return false;
            }
            if (button == 1) {
                DropdownMenu menu = DropdownMenu.builder(CatalogueModListScreen.this).setMinItemSize(0, 16).setAlignment(DropdownMenu.Alignment.BELOW_LEFT).addItem((Component)Component.translatable((String)"catalogue.gui.show_dependencies"), () -> {
                    String filter = "@dependencies:" + this.data.getModId();
                    CatalogueModListScreen.this.searchTextField.setValue(filter);
                }).addItem((Component)Component.translatable((String)"catalogue.gui.show_dependents"), () -> {
                    String filter = "@dependents:" + this.data.getModId();
                    CatalogueModListScreen.this.searchTextField.setValue(filter);
                }).build();
                menu.toggle((int)mouseX, (int)mouseY);
                return false;
            }
            if (button == 0) {
                CatalogueModListScreen.this.setSelectedModData(this.data);
                this.list.setSelected((AbstractSelectionList.Entry)this);
                return true;
            }
            return false;
        }

        public IModData getData() {
            return this.data;
        }

        public Component getNarration() {
            return Component.literal((String)this.data.getDisplayName());
        }

        private class PinnedButton
        extends AbstractButton {
            private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"textures/gui/icons.png");
            private final String modId;

            public PinnedButton(String modId) {
                super(0, 0, 10, 10, CommonComponents.EMPTY);
                this.modId = modId;
            }

            protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                int textureU = FAVOURITES.has(this.modId) ? 10 : 0;
                graphics.blit(TEXTURE, this.getX(), this.getY(), (float)textureU, 10.0f, 10, 10, 64, 64);
            }

            public void onPress() {
                FAVOURITES.toggle(this.modId);
                ModListEntry.this.list.filterAndUpdateList();
            }

            protected void updateWidgetNarration(NarrationElementOutput output) {
                this.defaultButtonNarrationText(output);
            }
        }
    }

    private record SearchFilter(BiPredicate<String, IModData> predicate) {
    }

    private class StringEntry
    extends ObjectSelectionList.Entry<StringEntry> {
        private final String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.drawString(CatalogueModListScreen.this.font, this.line, left, top, 0xFFFFFF);
        }

        public Component getNarration() {
            return Component.literal((String)this.line);
        }
    }
}

