/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.stepped_lever;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.dndecor.content.blocks.stepped_lever.SteppedLeverBlockEntity;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import dev.lopyluna.dndecor.register.DnDecorShapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SteppedLeverBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IBE<SteppedLeverBlockEntity> {
    public static final MapCodec<AnalogLeverBlock> CODEC = SteppedLeverBlock.simpleCodec(AnalogLeverBlock::new);

    public SteppedLeverBlock(BlockBehaviour.Properties p_i48402_1_) {
        super(p_i48402_1_);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            SteppedLeverBlock.addParticles(state, (LevelAccessor)worldIn, pos, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            boolean sneak = player.isShiftKeyDown();
            be.changeState(sneak);
            float f = 0.25f + (float)(be.state + 5) / 15.0f * 0.5f;
            worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.2f, f);
            return InteractionResult.SUCCESS;
        });
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.getBlockEntityOptional(blockAccess, pos).map(al -> al.state).orElse(0);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return SteppedLeverBlock.getConnectedDirection((BlockState)blockState) == side ? this.getSignal(blockState, blockAccess, pos, side) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.state != 0 && rand.nextFloat() < 0.25f) {
                SteppedLeverBlock.addParticles(stateIn, (LevelAccessor)worldIn, pos, 0.5f);
            }
        });
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (isMoving || state.getBlock() == newState.getBlock()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.state != 0) {
                SteppedLeverBlock.updateNeighbors(state, worldIn, pos);
            }
            worldIn.removeBlockEntity(pos);
        });
    }

    private static void addParticles(BlockState state, LevelAccessor worldIn, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        Direction direction1 = SteppedLeverBlock.getConnectedDirection((BlockState)state).getOpposite();
        double d0 = (double)pos.getX() + 0.5 + 0.1 * (double)direction.getStepX() + 0.2 * (double)direction1.getStepX();
        double d1 = (double)pos.getY() + 0.5 + 0.1 * (double)direction.getStepY() + 0.2 * (double)direction1.getStepY();
        double d2 = (double)pos.getZ() + 0.5 + 0.1 * (double)direction.getStepZ() + 0.2 * (double)direction1.getStepZ();
        worldIn.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), alpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    static void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, state.getBlock());
        world.updateNeighborsAt(pos.relative(SteppedLeverBlock.getConnectedDirection((BlockState)state).getOpposite()), state.getBlock());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        AttachFace face = (AttachFace)state.getValue((Property)FACE);
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape voxelShape = face == AttachFace.CEILING ? DnDecorShapes.STEPPED_LEVER_CEILING.get(direction.getOpposite()) : (shape = face == AttachFace.FLOOR ? DnDecorShapes.STEPPED_LEVER.get(direction.getOpposite()) : DnDecorShapes.STEPPED_LEVER_WALL.get(direction));
        if (shape != null) {
            return shape;
        }
        return super.getShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, FACE}));
    }

    public Class<SteppedLeverBlockEntity> getBlockEntityClass() {
        return SteppedLeverBlockEntity.class;
    }

    public BlockEntityType<? extends SteppedLeverBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DnDecorBETypes.STEPPED_LEVER.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

