/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.list_providers;

import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.content.entries.BoltEntry;
import dev.lopyluna.dndecor.register.helpers.list_providers.MaterialTypeProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class MetalTypeBoltBlockList<T extends Block>
implements Iterable<BoltEntry<T>> {
    private final BoltEntry<?>[] values = new BoltEntry[MaterialTypeProvider.metalTypes.size()];

    public MetalTypeBoltBlockList(Function<NonNullSupplier<MaterialTypeProvider.MetalType>, BoltEntry<? extends T>> filler) {
        for (NonNullSupplier<MaterialTypeProvider.MetalType> type : MaterialTypeProvider.metalTypes) {
            int index = MaterialTypeProvider.metalTypes.indexOf(type);
            if (index < 0) continue;
            this.values[index] = filler.apply(type);
        }
    }

    public BoltEntry<T> get(MaterialTypeProvider.MetalType metal) {
        NonNullSupplier type = () -> metal;
        int index = MaterialTypeProvider.metalTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public BoltEntry<T> get(NonNullSupplier<MaterialTypeProvider.MetalType> type) {
        int index = MaterialTypeProvider.metalTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public boolean contains(Block block) {
        for (BoltEntry<?> entry : this.values) {
            if (!entry.is(block)) continue;
            return true;
        }
        return false;
    }

    public BoltEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public Iterator<BoltEntry<T>> iterator() {
        return new Iterator<BoltEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < MetalTypeBoltBlockList.this.values.length;
            }

            @Override
            public BoltEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MetalTypeBoltBlockList.this.values[this.index++];
            }
        };
    }
}

