/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.attachment.client;

import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.ClientAttachments;
import com.alrex.parcool.common.attachment.common.ReadonlyStamina;
import com.alrex.parcool.common.stamina.IParCoolStaminaHandler;
import com.alrex.parcool.common.stamina.StaminaType;
import com.alrex.parcool.common.stamina.handlers.InfiniteStaminaHandler;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LocalStamina {
    @Nullable
    private StaminaType currentType = null;
    @Nullable
    private IParCoolStaminaHandler handler = null;

    public static LocalStamina get(LocalPlayer player) {
        return (LocalStamina)player.getData(ClientAttachments.LOCAL_STAMINA);
    }

    public boolean isAvailable() {
        return this.handler != null && this.currentType != null;
    }

    public boolean isInfinite(LocalPlayer player) {
        return player.isCreative() || player.isSpectator() || this.handler instanceof InfiniteStaminaHandler;
    }

    public void changeType(LocalPlayer player, StaminaType type) {
        this.currentType = type;
        this.handler = type.newHandler();
        player.setData(Attachments.STAMINA, (Object)this.handler.initializeStamina(player, (ReadonlyStamina)player.getData(Attachments.STAMINA)));
    }

    public boolean isExhausted(LocalPlayer player) {
        return ((ReadonlyStamina)player.getData(Attachments.STAMINA)).isExhausted();
    }

    public int getValue(LocalPlayer player) {
        return ((ReadonlyStamina)player.getData(Attachments.STAMINA)).value();
    }

    public int getMax(LocalPlayer player) {
        return ((ReadonlyStamina)player.getData(Attachments.STAMINA)).max();
    }

    public void consume(LocalPlayer player, int value) {
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        if (this.handler == null) {
            return;
        }
        player.setData(Attachments.STAMINA, (Object)this.handler.consume(player, (ReadonlyStamina)player.getData(Attachments.STAMINA), value));
    }

    public void recover(LocalPlayer player, int value) {
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        if (this.handler == null) {
            return;
        }
        player.setData(Attachments.STAMINA, (Object)this.handler.recover(player, (ReadonlyStamina)player.getData(Attachments.STAMINA), value));
    }

    public void onTick(LocalPlayer player) {
        if (this.handler == null) {
            return;
        }
        player.setData(Attachments.STAMINA, (Object)this.handler.onTick(player, (ReadonlyStamina)player.getData(Attachments.STAMINA)));
    }

    public void sync(LocalPlayer player) {
        ((ReadonlyStamina)player.getData(Attachments.STAMINA)).sync(player);
    }
}

