/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.handlers;

import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.HideInBlock;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.attachment.common.Parkourability;
import com.alrex.parcool.common.network.payload.StartBreakfallEventPayload;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerDamageHandler {
    @SubscribeEvent
    public static void onAttack(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            Dodge dodge = parkourability.get(Dodge.class);
            if (dodge.isDoing()) {
                if (!parkourability.getServerLimitation().get(ParCoolConfig.Server.Booleans.DodgeProvideInvulnerableFrame).booleanValue()) {
                    return;
                }
                if (event.getSource().is(DamageTypeTags.BYPASSES_ARMOR)) {
                    return;
                }
                if (dodge.getDoingTick() <= 10) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            if (parkourability.get(BreakfallReady.class).isDoing() && (parkourability.getActionInfo().can(Tap.class) || parkourability.getActionInfo().can(Roll.class))) {
                boolean justTime = parkourability.get(BreakfallReady.class).getDoingTick() < 5;
                float distance = event.getDistance();
                if (distance > 2.0f) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StartBreakfallEventPayload(justTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (distance < 6.0f || justTime && distance < 8.0f) {
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(event.getDamageMultiplier() * (justTime ? 0.4f : 0.6f));
                }
            } else {
                Tuple<BlockPos, BlockPos> area;
                HideInBlock hideInBlock = parkourability.get(HideInBlock.class);
                if (hideInBlock.isStandbyInAir(parkourability) && parkourability.getActionInfo().can(HideInBlock.class) && !((ParCoolActionEvent.TryToStartEvent)NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent((Player)player, hideInBlock))).isCanceled() && (area = WorldUtil.getHideAbleSpace((Entity)player, player.blockPosition().below())) != null) {
                    boolean stand;
                    boolean bl = stand = player.getBbHeight() < (float)(Math.abs(((BlockPos)area.getB()).getY() - ((BlockPos)area.getA()).getY()) + 1);
                    if (!stand) {
                        if (event.getDistance() < 10.0f) {
                            event.setCanceled(true);
                        } else {
                            event.setDamageMultiplier(event.getDamageMultiplier() * 0.4f);
                        }
                    }
                }
            }
        } else if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (!player.isLocalPlayer()) {
                return;
            }
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            if (parkourability.getAdditionalProperties().getNotLandingTick() > 5 && event.getDistance() < 0.4f) {
                parkourability.get(ChargeJump.class).onLand(player, parkourability);
            }
        }
    }
}

