/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ContainerInput;
import java.util.stream.IntStream;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardCombiningRecipe
implements Recipe<ContainerInput> {
    public static final int MAX_INGREDIENTS = 5;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;

    public CuttingBoardCombiningRecipe(NonNullList<Ingredient> ingredients, ItemStack result) {
        this.ingredients = ingredients;
        this.result = result;
    }

    public boolean matches(ContainerInput input, Level level) {
        for (int i = 0; i < this.ingredients.size() && i < input.size(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(input.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(ContainerInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean completelyMatches(Container container) {
        if (this.ingredients.size() <= container.getContainerSize()) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(container.getItem(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder
    implements RecipeBuilder {
        private final NonNullList<Ingredient> ingredients = NonNullList.create();
        private final ItemStack result;

        public Builder(ItemStack output) {
            this.result = output;
        }

        public Builder add(Ingredient ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support unlocking");
        }

        public RecipeBuilder group(@Nullable String group) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support setting the group");
        }

        public Item getResult() {
            return this.result.getItem();
        }

        public void save(RecipeOutput output, ResourceLocation id) {
            this.validate();
            output.accept(id, (Recipe)new CuttingBoardCombiningRecipe(this.ingredients, this.result), null);
        }

        private void validate() {
            if (this.ingredients.size() < 2) {
                throw new IllegalStateException("Cutting Board combining recipe must have at least 2 input ingredients");
            }
            if (this.ingredients.size() > 5) {
                throw new IllegalStateException("Cutting Board combining recipe only supports up to 5 input ingredients");
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<CuttingBoardCombiningRecipe> {
        public static final MapCodec<CuttingBoardCombiningRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] inputs = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (inputs.length > 5) {
                return DataResult.error(() -> "Too many ingredients");
            }
            if (inputs.length == 0) {
                return DataResult.error(() -> "No ingredients");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])inputs));
        }, DataResult::success).forGetter(recipe -> recipe.getIngredients()), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, CuttingBoardCombiningRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CuttingBoardCombiningRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            buf.writeInt(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> Ingredient.CONTENTS_STREAM_CODEC.encode(buf, ingredient));
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.result);
        }, buf -> {
            int ingredientCount = buf.readInt();
            NonNullList ingredients = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
            IntStream.range(0, ingredientCount).forEach(i -> ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf))));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            return new CuttingBoardCombiningRecipe((NonNullList<Ingredient>)ingredients, result);
        });

        public MapCodec<CuttingBoardCombiningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CuttingBoardCombiningRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

