/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.image;

import com.mojang.blaze3d.platform.NativeImage;
import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public class TextureCache {
    private static final long EXPIRE_TIME = 10000L;
    private static TextureCache instance;
    private final Map<ResourceLocation, Entry> entries = new HashMap<ResourceLocation, Entry>();

    public static TextureCache get() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    private TextureCache() {
    }

    public void tick() {
        this.entries.entrySet().removeIf(e -> {
            Entry entry = (Entry)e.getValue();
            if (entry.isExpired()) {
                Minecraft.getInstance().getTextureManager().release(entry.getId());
                return true;
            }
            return false;
        });
    }

    @Nullable
    public ResourceLocation getOrCacheImage(IPaintable paintable) {
        PaletteImage image = paintable.getImage();
        if (image != null) {
            Entry entry = this.entries.get(image.getId());
            if (entry == null) {
                entry = new Entry(image);
                this.entries.put(image.getId(), entry);
            }
            entry.ping();
            return image.getId();
        }
        return null;
    }

    private static NativeImage convertToNativeImage(PaletteImage image) {
        NativeImage nativeImage = new NativeImage(image.width, image.height, false);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int colour = PaletteImage.COLOURS[image.get(x, y)];
                colour = TextureCache.convertARGBToABGR(colour);
                nativeImage.setPixelRGBA(x, y, colour);
            }
        }
        return nativeImage;
    }

    private static int convertARGBToABGR(int value) {
        int alpha = FastColor.ARGB32.alpha((int)value);
        int red = FastColor.ARGB32.red((int)value);
        int green = FastColor.ARGB32.green((int)value);
        int blue = FastColor.ARGB32.blue((int)value);
        return FastColor.ABGR32.color((int)alpha, (int)blue, (int)green, (int)red);
    }

    private static class Entry {
        private final ResourceLocation id;
        private long lastDrawTime;

        public Entry(PaletteImage image) {
            this.id = image.getId();
            DynamicTexture texture = new DynamicTexture(TextureCache.convertToNativeImage(image));
            Minecraft.getInstance().getTextureManager().register(image.getId(), (AbstractTexture)texture);
            this.lastDrawTime = Util.getMillis();
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public void ping() {
            this.lastDrawTime = Util.getMillis();
        }

        public boolean isExpired() {
            return Util.getMillis() - this.lastDrawTime > 10000L;
        }
    }
}

