/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownSwordEntity
extends ThrowableItemProjectile {
    private static final int MAX_DURATION = 100;
    private int duration;

    public ThrownSwordEntity(EntityType<? extends ThrownSwordEntity> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        ++this.duration;
        if (!this.level().isClientSide && this.duration > 100) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected Item getDefaultItem() {
        return Items.IRON_SWORD;
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("duration", this.duration);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.duration = pCompound.getInt("duration");
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity target = pResult.getEntity();
        if (this.friendlyFire(target)) {
            return;
        }
        if (!this.level().isClientSide) {
            target.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 6.0f);
        }
    }

    private boolean friendlyFire(Entity target) {
        Entity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return target == owner || target instanceof IFamiliar && ((IFamiliar)target).getFamiliarOwner() == owner;
    }
}

