/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe.conditionextension;

import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionVisitor;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionWrapperFactory;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.OccultismConditionContext;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInBiomeCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInBiomeWithTagCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInDimensionCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInDimensionTypeCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.AndConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.FalseConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.ItemExistsConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.ModLoadedConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.NotConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.OrConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.TagEmptyConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.TrueConditionWrapper;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public class RitualRecipeConditionFailureInformationVisitor
implements ConditionVisitor {
    @Override
    public MutableComponent visit(AndConditionWrapper condition, OccultismConditionContext context) {
        MutableComponent contained = Component.empty();
        List children = condition.condition().children();
        boolean isFirst = true;
        for (ICondition child : children) {
            if (condition.condition().test((ICondition.IContext)context)) continue;
            MutableComponent c = ConditionWrapperFactory.wrap(child).accept(this, context);
            if (isFirst) {
                isFirst = false;
                contained.append("\n\n").append("(").append((Component)c).append(")");
                continue;
            }
            contained.append("\n AND \n").append("(").append((Component)c).append(")");
        }
        return Component.translatable((String)"condition.occultism.ritual.and.not_fulfilled", (Object[])new Object[]{contained});
    }

    @Override
    public MutableComponent visit(OrConditionWrapper condition, OccultismConditionContext context) {
        MutableComponent contained = Component.empty();
        List children = condition.condition().values();
        boolean isFirst = true;
        for (ICondition child : children) {
            if (condition.condition().test((ICondition.IContext)context)) continue;
            MutableComponent c = ConditionWrapperFactory.wrap(child).accept(this, context);
            if (isFirst) {
                isFirst = false;
                contained.append("\n\n").append("(").append((Component)c).append(")");
                continue;
            }
            contained.append("\n OR \n").append("(").append((Component)c).append(")");
        }
        return Component.translatable((String)"condition.occultism.ritual.or.not_fulfilled", (Object[])new Object[]{contained});
    }

    @Override
    public MutableComponent visit(TrueConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.true.not_fulfilled");
    }

    @Override
    public MutableComponent visit(FalseConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.false.not_fulfilled");
    }

    @Override
    public MutableComponent visit(NotConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.not.not_fulfilled", (Object[])new Object[]{ConditionWrapperFactory.wrap(condition.condition().value()).accept(this, context)});
    }

    @Override
    public MutableComponent visit(ItemExistsConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.item_exists.not_fulfilled", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)condition.condition().getItem()))});
    }

    @Override
    public MutableComponent visit(ModLoadedConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.mod_loaded.not_fulfilled", (Object[])new Object[]{condition.condition().modid()});
    }

    @Override
    public MutableComponent visit(TagEmptyConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.tag_empty.not_fulfilled", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"tag", (ResourceLocation)condition.condition().tag().location()))});
    }

    @Override
    public MutableComponent visit(IsInBiomeCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_biome.not_fulfilled", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)condition.biome().unwrapKey().orElseThrow()).location())), Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)context.biome().unwrapKey().orElseThrow()).location()))});
    }

    @Override
    public MutableComponent visit(IsInBiomeWithTagCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_biome_with_tag.not_fulfilled", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"tag", (ResourceLocation)condition.tag().location())), Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)context.biome().unwrapKey().orElseThrow()).location()))});
    }

    @Override
    public MutableComponent visit(IsInDimensionCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_dimension.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)condition.dimension().location())), Component.translatable((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)context.dimension().location()))});
    }

    @Override
    public MutableComponent visit(IsInDimensionTypeCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_dimension_type.not_fulfilled", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"dimension_type", (ResourceLocation)((ResourceKey)condition.dimensionType().unwrapKey().orElseThrow()).location())), Component.translatable((String)Util.makeDescriptionId((String)"dimension_type", (ResourceLocation)((ResourceKey)context.dimensionType().unwrapKey().orElseThrow()).location()))});
    }
}

