/*
 * Decompiled with CFR 0.152.
 */
package net.sabitron.sillyworks.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.sabitron.sillyworks.init.SillyworksModBlocks;
import net.sabitron.sillyworks.init.SillyworksModFluidTypes;
import net.sabitron.sillyworks.init.SillyworksModFluids;
import net.sabitron.sillyworks.init.SillyworksModItems;
import net.sabitron.sillyworks.procedures.MoltenSiliconCollideWaterProcedure;

public abstract class MoltenSiliconFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)SillyworksModFluidTypes.MOLTEN_SILICON_TYPE.get(), () -> (Fluid)SillyworksModFluids.MOLTEN_SILICON.get(), () -> (Fluid)SillyworksModFluids.FLOWING_MOLTEN_SILICON.get()).explosionResistance(100.0f).tickRate(40).levelDecreasePerBlock(2).slopeFindDistance(5).bucket(() -> (Item)SillyworksModItems.MOLTEN_SILICON_BUCKET.get()).block(() -> (LiquidBlock)SillyworksModBlocks.MOLTEN_SILICON.get());

    private MoltenSiliconFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_LAVA;
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState blockstate) {
        MoltenSiliconCollideWaterProcedure.execute(world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }

    public static class Flowing
    extends MoltenSiliconFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends MoltenSiliconFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

