/*
 * Decompiled with CFR 0.152.
 */
package net.sabitron.sillyworks.fluid;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.sabitron.sillyworks.init.SillyworksModBlocks;
import net.sabitron.sillyworks.init.SillyworksModFluidTypes;
import net.sabitron.sillyworks.init.SillyworksModFluids;

public abstract class PurpleSodaFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)SillyworksModFluidTypes.PURPLE_SODA_TYPE.get(), () -> (Fluid)SillyworksModFluids.PURPLE_SODA.get(), () -> (Fluid)SillyworksModFluids.FLOWING_PURPLE_SODA.get()).explosionResistance(100.0f).tickRate(4).slopeFindDistance(5).block(() -> (LiquidBlock)SillyworksModBlocks.PURPLE_SODA.get());

    private PurpleSodaFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_LAVA;
    }

    public static class Flowing
    extends PurpleSodaFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends PurpleSodaFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

