/*
 * Decompiled with CFR 0.152.
 */
package net.sabitron.sillyworks.item;

import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.sabitron.sillyworks.init.SillyworksModItems;

public class LaserItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 256;
        }

        public float getSpeed() {
            return 0.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 3;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)SillyworksModItems.IRON_COMPONENT.get()), new ItemStack((ItemLike)Items.QUARTZ), new ItemStack((ItemLike)Items.REDSTONE), new ItemStack((ItemLike)SillyworksModItems.BASIC_PROCESSOR.get()), new ItemStack((ItemLike)SillyworksModItems.UPGRADED_PROCESSOR.get()), new ItemStack((ItemLike)SillyworksModItems.MICROPROCESSOR.get())});
        }
    };

    public LaserItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)0.0f, (float)0.0f)));
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack retval = new ItemStack((ItemLike)this);
        retval.setDamageValue(itemstack.getDamageValue() + 1);
        if (retval.getDamageValue() >= retval.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        return retval;
    }

    public boolean isRepairable(ItemStack itemstack) {
        return false;
    }
}

