/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.data;

import com.rosebushes.alchemyexpanded.data.AEBlockTags;
import com.rosebushes.alchemyexpanded.data.AEDamageTypeProvider;
import com.rosebushes.alchemyexpanded.data.AEEnchantmentTagsProvider;
import com.rosebushes.alchemyexpanded.data.AEItemTags;
import com.rosebushes.alchemyexpanded.data.AEMinecraftEnchantmentTagsProvider;
import com.rosebushes.alchemyexpanded.data.loot_table.AELootTableProvider;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantments;
import com.rosebushes.alchemyexpanded.recipe.AERecipeProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="alchemyexpanded")
public class AEData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DatapackBuiltinEntriesProvider builtinEntries = (DatapackBuiltinEntriesProvider)gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), AEData.registrySetBuilder(), Set.of("alchemyexpanded")));
        CompletableFuture lookupProvider = builtinEntries.getRegistryProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new AERecipeProvider(output, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new AEDamageTypeProvider.Tags(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)AELootTableProvider.create(output, lookupProvider));
        AEBlockTags blockTags = (AEBlockTags)gen.addProvider(event.includeServer(), (DataProvider)new AEBlockTags(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AEItemTags(output, lookupProvider, blockTags.contentsGetter(), fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AEEnchantmentTagsProvider(output, lookupProvider, "alchemyexpanded", fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AEMinecraftEnchantmentTagsProvider(output, lookupProvider, fileHelper));
    }

    private static RegistrySetBuilder registrySetBuilder() {
        return new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, AEDamageTypeProvider::register).add(Registries.ENCHANTMENT, AEEnchantments::bootstrap);
    }
}

