/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.entity;

import com.rosebushes.alchemyexpanded.AlchemyExpanded;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;

public class AEDamage {
    public static final ResourceKey<DamageType> GUN = AEDamage.key("gun");
    public static final ResourceKey<DamageType> CUEBALL_GUN = AEDamage.key("cueball_gun");
    public static final ResourceKey<DamageType> LASER = AEDamage.key("laser");

    private static ResourceKey<DamageType> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)AlchemyExpanded.id(name));
    }

    private static Holder<DamageType> getType(RegistryAccess registryAccess, ResourceKey<DamageType> key) {
        return registryAccess.registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(key);
    }

    public static DamageSource gun(RegistryAccess registryAccess) {
        return new DamageSource(AEDamage.getType(registryAccess, GUN));
    }

    public static DamageSource gun(RegistryAccess registryAccess, Entity shooter) {
        return new DamageSource(AEDamage.getType(registryAccess, GUN), shooter);
    }

    public static DamageSource gun(RegistryAccess registryAccess, Entity projectile, Entity shooter) {
        return new DamageSource(AEDamage.getType(registryAccess, GUN), projectile, shooter);
    }

    public static DamageSource cueballGun(RegistryAccess registryAccess) {
        return new DamageSource(AEDamage.getType(registryAccess, CUEBALL_GUN));
    }

    public static DamageSource cueballGun(RegistryAccess registryAccess, Entity shooter) {
        return new DamageSource(AEDamage.getType(registryAccess, CUEBALL_GUN), shooter);
    }

    public static DamageSource cueballGun(RegistryAccess registryAccess, Entity projectile, Entity shooter) {
        return new DamageSource(AEDamage.getType(registryAccess, CUEBALL_GUN), projectile, shooter);
    }

    public static DamageSource laser(RegistryAccess registryAccess) {
        return new DamageSource(AEDamage.getType(registryAccess, LASER));
    }

    public static DamageSource laser(RegistryAccess registryAccess, Entity shooter) {
        return new DamageSource(AEDamage.getType(registryAccess, LASER), shooter);
    }

    public static DamageSource laser(RegistryAccess registryAccess, Entity projectile, Entity shooter) {
        return new DamageSource(AEDamage.getType(registryAccess, LASER), projectile, shooter);
    }
}

