/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.entity;

import com.rosebushes.alchemyexpanded.entity.AEDamage;
import com.rosebushes.alchemyexpanded.entity.AEEntities;
import com.rosebushes.alchemyexpanded.item.AEItems;
import com.rosebushes.alchemyexpanded.network.BulletEffectPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class ProjectileEntity
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected double damage;
    private ItemStack item = ItemStack.EMPTY;
    protected int sinceSpawned;
    private static final double STOP_TRESHOLD = 0.01;

    public ProjectileEntity(EntityType<? extends ProjectileEntity> type, Level world) {
        super(type, world);
    }

    public ProjectileEntity(Level world, LivingEntity shooter) {
        this(AEEntities.BASIC_BULLET.get(), shooter, world);
    }

    protected ProjectileEntity(EntityType<? extends ProjectileEntity> type, LivingEntity shooter, Level world) {
        this(type, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), world);
        this.setOwner((Entity)shooter);
        this.setRot(shooter.getYRot(), shooter.getXRot());
    }

    protected ProjectileEntity(EntityType<? extends ProjectileEntity> type, double x, double y, double z, Level world) {
        this(type, world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
    }

    protected HitResult getHitResult() {
        EntityHitResult hitresult1;
        Vec3 pos = this.position();
        Vec3 vel = this.getDeltaMovement();
        Vec3 nextpos = pos.add(vel);
        BlockHitResult hitresult = this.level().clip(new ClipContext(pos, nextpos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (!this.noPhysics && hitresult.getType() != HitResult.Type.MISS) {
            nextpos = hitresult.getLocation();
        }
        if ((hitresult1 = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pos, (Vec3)nextpos, (AABB)this.getBoundingBox().expandTowards(vel).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0))) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public void tick() {
        ++this.sinceSpawned;
        if (this.sinceSpawned > 100 || this.getDeltaMovement().lengthSqr() < 0.01) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.onProjectileTick();
        Entity entity = this.getOwner();
        if (this.level().isClientSide || (entity == null || !entity.isRemoved()) && this.level().hasChunkAt(this.blockPosition())) {
            super.tick();
            this.processCollision();
            this.checkInsideBlocks();
            Vec3 vec3 = this.getDeltaMovement();
            double nextx = this.getX() + vec3.x;
            double nexty = this.getY() + vec3.y;
            double nextz = this.getZ() + vec3.z;
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, nextx - vec3.x * 0.25, nexty - vec3.y * 0.25, nextz - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
                }
                this.setDeltaMovement(vec3.scale(this.waterInertia()));
            }
            this.level().addParticle(this.getParticleTrail(), nextx, nexty + 0.5, nextz, 0.0, 0.0, 0.0);
            this.setPos(nextx, nexty, nextz);
        } else {
            this.discard();
        }
    }

    protected void processCollision() {
        HitResult hitresult = this.getHitResult();
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    protected double waterInertia() {
        return 0.8;
    }

    protected void onProjectileTick() {
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        super.onHitEntity(raytrace);
        this.onProjectileHitEntity(raytrace);
        if (!this.level().isClientSide) {
            boolean damaged;
            float adjustedDamage;
            Entity target = raytrace.getEntity();
            Entity shooter = this.getOwner();
            if (this.isOnFire()) {
                target.setRemainingFireTicks(100);
            }
            int lastHurtResistant = target.invulnerableTime;
            target.invulnerableTime = 0;
            double hitdamage = this.damage;
            float f = adjustedDamage = this.sinceSpawned > 20 ? (float)hitdamage * 0.5f : (float)hitdamage;
            if (this.sinceSpawned > 30) {
                adjustedDamage = (float)hitdamage * 0.25f;
            }
            boolean bl = damaged = shooter == null ? target.hurt(AEDamage.gun(this.level().registryAccess()), adjustedDamage) : target.hurt(AEDamage.gun(this.level().registryAccess(), (Entity)this, shooter), adjustedDamage);
            if (shooter != null) {
                Vec3 eyePos = target.getEyePosition(1.0f);
                Vec3 lookVec = shooter.getLookAngle();
                this.sendEffectPacket((ServerLevel)shooter.level(), eyePos, lookVec);
            }
            if (!damaged) {
                target.invulnerableTime = lastHurtResistant;
            }
        }
    }

    protected void sendEffectPacket(ServerLevel level, Vec3 pos, Vec3 lookVec) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)64.0, (CustomPacketPayload)new BulletEffectPacket(pos, lookVec), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!(this.level().isClientSide || this.noPhysics && result.getType() == HitResult.Type.BLOCK || !this.shouldDespawnOnHit(result))) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void onProjectileHitEntity(EntityHitResult result) {
    }

    protected boolean shouldDespawnOnHit(HitResult result) {
        return true;
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.noPhysics) {
            return;
        }
        super.onHitBlock(result);
    }

    public void setWeapon(ItemStack weapon) {
        this.item = weapon;
    }

    public ItemStack getWeapon() {
        return this.item;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.sinceSpawned = compoundTag.getInt("tsf");
        this.damage = compoundTag.getDouble("damage");
        this.setWeapon((ItemStack)ItemStack.parse((HolderLookup.Provider)Minecraft.getInstance().player.level().registryAccess(), (Tag)compoundTag.get("Item")).get());
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putDouble("damage", this.damage);
        compoundTag.putInt("tsf", this.sinceSpawned);
        ItemStack stack = this.getWeapon();
        if (!stack.isEmpty()) {
            compoundTag.put("Item", stack.save((HolderLookup.Provider)Minecraft.getInstance().player.level().registryAccess()));
        }
    }

    public void shootFromRotation(Entity shooter, float xRot, float yRot, float upArc, float speed, float spread) {
        float f = -Mth.sin((float)(yRot * ((float)Math.PI / 180))) * Mth.cos((float)(xRot * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((xRot + upArc) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(yRot * ((float)Math.PI / 180))) * Mth.cos((float)(xRot * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, speed, spread);
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double sqrDistance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return sqrDistance < (d0 *= 64.0) * d0;
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)AEItems.DUMMY_BULLET.get());
    }

    protected ParticleOptions getParticleTrail() {
        return ParticleTypes.SMOKE;
    }
}

